/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UrlUtil {
    private static final String UTF_8 = "UTF-8";

    public static Map<String, Object> getUrlParams(String url) {
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        if (StringUtils.isBlank((CharSequence)url)) {
            return map;
        }
        String[] split = url.split("\\?");
        if (split.length > 1) {
            String[] params = split[1].split("&");
            for (int i = 0; i < params.length; ++i) {
                String[] p = params[i].split("=");
                if (p.length != 2) continue;
                map.put(p[0], p[1]);
            }
        }
        return map;
    }

    public static String getFileName(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        String urlWithoutParameter = url.split("\\?")[0];
        return urlWithoutParameter.substring(urlWithoutParameter.lastIndexOf("/") + 1, urlWithoutParameter.length());
    }

    public static String getUrlWithoutParameter(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        return url.split("\\?")[0];
    }

    public static String getFileNameSuffix(String url) {
        String[] split = UrlUtil.getFileName(url).split("\\.");
        return split.length > 1 ? split[1] : "";
    }

    public static String getFileNameWithoutSuffix(String url) {
        String fileName = UrlUtil.getFileName(url);
        return fileName.split("\\.")[0];
    }

    public static String urlEncode(String content) {
        try {
            if (StringUtils.isNotBlank((CharSequence)content)) {
                String result = URLEncoder.encode(content, UTF_8);
                return result;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return content;
    }

    public static String urlDecode(String content) {
        try {
            if (StringUtils.isNotBlank((CharSequence)content)) {
                String result = URLDecoder.decode(content, UTF_8);
                return result;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return content;
    }
}

