/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util;

import com.ella.util.os.OSinfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtil {
    private static final Logger logger = LoggerFactory.getLogger(IpUtil.class);
    private static String macAddressStr = null;
    private static final String[] windowsCommand = new String[]{"ipconfig", "/all"};
    private static final String[] linuxCommand = new String[]{"/sbin/ifconfig", "-a"};
    private static final Pattern macPattern = Pattern.compile(".*((:?[0-9a-f]{2}[-:]){5}[0-9a-f]{2}).*", 2);

    public static Map<String, String> getDeviceInformation(HttpServletRequest request) {
        HashMap<String, String> resMap = new HashMap<String, String>(4);
        Properties props = System.getProperties();
        resMap.put("systemVersion", OSinfo.getOSname().toString());
        Map<String, String> map = System.getenv();
        resMap.put("computerName", map.get("COMPUTERNAME"));
        resMap.put("deviceIp", IpUtil.getClientIp(request));
        resMap.put("deviceMark", IpUtil.getComputerID());
        return resMap;
    }

    public static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        logger.debug("x-forwarded-for = {}", (Object)ip);
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
            logger.debug("Proxy-Client-IP = {}", (Object)ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
            logger.debug("WL-Proxy-Client-IP = {}", (Object)ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
            logger.debug("RemoteAddr-IP = {}", (Object)ip);
        }
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            ip = ip.split(",")[0];
        }
        return ip;
    }

    public static String getMACAddress() {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            return IpUtil.getMACAddress(ia);
        }
        catch (UnknownHostException e) {
            logger.error("getMACAddress()\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static String getMACAddress(InetAddress ia) {
        try {
            byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append("-");
                }
                sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
            }
            return sb.toString().toUpperCase();
        }
        catch (SocketException e) {
            logger.error("getMACAddress\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }

    private static final List<String> getMacAddressList() throws IOException {
        String[] command;
        ArrayList<String> macAddressList = new ArrayList<String>();
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            command = windowsCommand;
        } else if (os.startsWith("Linux")) {
            command = linuxCommand;
        } else {
            throw new IOException("Unknow operating system:" + os);
        }
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = null;
        while ((line = bufReader.readLine()) != null) {
            Matcher matcher = macPattern.matcher(line);
            if (!matcher.matches()) continue;
            macAddressList.add(matcher.group(1));
        }
        process.destroy();
        bufReader.close();
        return macAddressList;
    }

    public static String getMacAddress() {
        if (macAddressStr == null || macAddressStr.equals("")) {
            StringBuffer sb = new StringBuffer();
            try {
                List<String> macList = IpUtil.getMacAddressList();
                for (String amac : macList) {
                    if (amac.equals("0000000000E0")) continue;
                    sb.append(amac);
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            macAddressStr = sb.toString();
        }
        return macAddressStr;
    }

    public static String getIpAddrAndName() throws IOException {
        return InetAddress.getLocalHost().toString();
    }

    public static String getComputerID() {
        String id = IpUtil.getMacAddress();
        if (id == null || id.equals("")) {
            try {
                id = IpUtil.getIpAddrAndName();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return id;
    }
}

