/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;

public class FileUtil {
    public static void delFile(File path) {
        if (!path.exists()) {
            return;
        }
        if (path.isFile()) {
            path.delete();
            return;
        }
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            FileUtil.delFile(files[i]);
        }
        path.delete();
    }

    public static void delFile(String path) {
        FileUtil.delFile(FileUtil.getFile(path));
    }

    public static File getFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File createFile(String path) throws IOException {
        return FileUtil.createFile(path, "/");
    }

    public static File createFile(String path, String separator) throws IOException {
        FileUtil.getFile(path.substring(0, path.lastIndexOf(separator)));
        File newFile = new File(path);
        if (!newFile.exists()) {
            newFile.createNewFile();
        }
        return newFile;
    }

    public static String getSuffix(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        String[] split = fileName.split("\\.");
        String suffix = split[split.length - 1];
        return suffix;
    }

    public static List<File> getImgFileList(String strPath) {
        List<String> imageTypes = FileUtil.imageTypes();
        LinkedList<File> fileList = new LinkedList<File>();
        File dir = new File(strPath);
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i].getName();
                if (files[i].isDirectory()) {
                    fileList.addAll(FileUtil.getImgFileList(files[i].getAbsolutePath()));
                    continue;
                }
                if (!imageTypes.contains(FileUtil.getSuffix(fileName))) continue;
                fileList.add(files[i]);
            }
        }
        return fileList;
    }

    public static List<String> imageTypes() {
        ArrayList<String> imageTypes = new ArrayList<String>();
        imageTypes.add("bmp");
        imageTypes.add("jpg");
        imageTypes.add("jpeg");
        imageTypes.add("png");
        imageTypes.add("gif");
        imageTypes.add("pcx");
        imageTypes.add("tiff");
        imageTypes.add("tga");
        imageTypes.add("exif");
        imageTypes.add("fpx");
        imageTypes.add("svg");
        imageTypes.add("psd");
        imageTypes.add("cdr");
        imageTypes.add("pcd");
        imageTypes.add("dxf");
        imageTypes.add("ufo");
        imageTypes.add("eps");
        imageTypes.add("ai");
        imageTypes.add("hdri");
        imageTypes.add("raw");
        imageTypes.add("wmf");
        imageTypes.add("lic");
        imageTypes.add("emf");
        return imageTypes;
    }

    public static List<String> videoTypes() {
        ArrayList<String> videoTypes = new ArrayList<String>();
        videoTypes.add("wav");
        videoTypes.add("mp3");
        videoTypes.add("aif");
        videoTypes.add("cda");
        videoTypes.add("mid");
        videoTypes.add("wma");
        return videoTypes;
    }

    public static void mkDir(File file) {
        if (file.getParentFile().exists()) {
            file.mkdir();
        } else {
            FileUtil.mkDir(file.getParentFile());
            file.mkdir();
        }
    }

    public static void writeToFile(String path, String fileName, String content) {
        try {
            File file = new File(path);
            FileUtil.mkDir(file);
            FileWriter writer = new FileWriter(path + "/" + fileName, true);
            if (content != null && !content.equals("")) {
                writer.write(content);
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testStr() {
        FileUtil.writeToFile("E:/et/e/et/rt", "test.txt", "1\n");
    }
}

