/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util;

import com.ella.constraint.inf.SetDefault;
import com.ella.constraint.inf.SetDefaultContainer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.internal.engine.path.PathImpl;

public class ValidatorUtil {
    private Validator validator;
    private boolean failFast = true;

    private ValidatorUtil() {
    }

    public ValidatorUtil getValidator(boolean failFast) {
        this.failFast = failFast;
        this.validator = failFast ? this.validator : ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(failFast).buildValidatorFactory().getValidator();
        return this;
    }

    public static ValidatorUtil getInstance() {
        ValidatorUtil validatorUtil = new ValidatorUtil();
        validatorUtil.validator = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true).buildValidatorFactory().getValidator();
        return validatorUtil;
    }

    public <T> String validAndGetMessage(T obj, Class<?> ... groups) throws Exception {
        this.isSetDefaultValidatorMust(obj);
        Set validate = this.validator.validate(obj, (Class[])groups);
        return ValidatorUtil.getValidatorMessageStr(validate);
    }

    public <T> String validAndGetMessage(T obj, String propertyName, Class<?> ... groups) throws Exception {
        this.isSetDefaultValidatorMust(obj);
        Set validate = this.validator.validateProperty(obj, propertyName, (Class[])groups);
        return ValidatorUtil.getValidatorMessageStr(validate);
    }

    public <T> String validAndGetMessage(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) throws Exception {
        Set validate = this.validator.validateValue(beanType, propertyName, value, (Class[])groups);
        return ValidatorUtil.getValidatorMessageStr(validate);
    }

    public <T> List<String> validAndGetMessageList(T obj, Class<?> ... groups) throws Exception {
        this.isSetDefaultValidatorMust(obj);
        Set validate = this.validator.validate(obj, (Class[])groups);
        return ValidatorUtil.getValidatorMessageList(validate);
    }

    public <T> List<String> validAndGetMessageList(T obj, String propertyName, Class<?> ... groups) throws Exception {
        this.isSetDefaultValidatorMust(obj);
        Set validate = this.validator.validateProperty(obj, propertyName, (Class[])groups);
        return ValidatorUtil.getValidatorMessageList(validate);
    }

    public <T> List<String> validAndGetMessageList(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) throws Exception {
        Set validate = this.validator.validateValue(beanType, propertyName, value, (Class[])groups);
        return ValidatorUtil.getValidatorMessageList(validate);
    }

    public <T> Map<String, String> validAndGetMessageMap(T obj, Class<?> ... groups) throws Exception {
        this.isSetDefaultValidatorMust(obj);
        Set validate = this.validator.validate(obj, (Class[])groups);
        return ValidatorUtil.getValidatorMessageMap(validate);
    }

    public <T> Map<String, String> validAndGetMessageMap(T obj, String propertyName, Class<?> ... groups) throws Exception {
        this.isSetDefaultValidatorMust(obj);
        Set validate = this.validator.validateProperty(obj, propertyName, (Class[])groups);
        return ValidatorUtil.getValidatorMessageMap(validate);
    }

    public <T> Map<String, String> validAndGetMessageMap(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) throws Exception {
        Set validate = this.validator.validateValue(beanType, propertyName, value, (Class[])groups);
        return ValidatorUtil.getValidatorMessageMap(validate);
    }

    private <T> void isSetDefaultValidatorMust(T obj) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(Arrays.asList(new Annotation[0]));
        if (!CollectionUtils.isEmpty(annotations)) {
            Iterator iterator = annotations.iterator();
            while (iterator.hasNext()) {
                String name = ((Annotation)iterator.next()).getClass().getName();
                if (SetDefaultContainer.getInstance().get(name) == null || !this.failFast) continue;
                this.getValidator(false);
                break;
            }
        }
    }

    public static <T> String getValidatorMessageStr(Set<ConstraintViolation<T>> constraintViolationList) throws Exception {
        if (CollectionUtils.isEmpty(constraintViolationList)) {
            return null;
        }
        constraintViolationList = ValidatorUtil.setFieldDefaultValue(constraintViolationList);
        String messages = constraintViolationList.stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(";\\n"));
        return messages;
    }

    public static <T> List<String> getValidatorMessageList(Set<ConstraintViolation<T>> constraintViolationList) throws Exception {
        if (CollectionUtils.isEmpty(constraintViolationList)) {
            return null;
        }
        constraintViolationList = ValidatorUtil.setFieldDefaultValue(constraintViolationList);
        List<String> messages = constraintViolationList.stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
        return messages;
    }

    public static <T> Map<String, String> getValidatorMessageMap(Set<ConstraintViolation<T>> constraintViolationList) throws Exception {
        if (CollectionUtils.isEmpty(constraintViolationList)) {
            return null;
        }
        constraintViolationList = ValidatorUtil.setFieldDefaultValue(constraintViolationList);
        HashMap<String, String> map = new HashMap<String, String>();
        constraintViolationList.iterator().forEachRemaining(tConstraintViolation -> {
            PathImpl propertyPath = (PathImpl)tConstraintViolation.getPropertyPath();
            String message = tConstraintViolation.getMessage();
            map.put(propertyPath.toString(), message);
        });
        return map;
    }

    private static <T> Set<ConstraintViolation<T>> setFieldDefaultValue(Set<ConstraintViolation<T>> constraintViolationList) throws Exception {
        Iterator<ConstraintViolation<T>> iterator = constraintViolationList.iterator();
        while (iterator.hasNext()) {
            ConstraintViolation<T> tConstraintViolation = iterator.next();
            Annotation annotation = tConstraintViolation.getConstraintDescriptor().getAnnotation();
            String name = annotation.annotationType().getName();
            SetDefault setDefault = SetDefaultContainer.getInstance().get(name);
            if (setDefault == null) continue;
            setDefault.setDefault(tConstraintViolation, annotation);
            iterator.remove();
        }
        return constraintViolationList;
    }
}

