/*
 * Decompiled with CFR 0.152.
 */
package com.ella.push;

import com.alibaba.fastjson.JSONObject;
import com.ella.push.AndroidNotification;
import com.ella.push.MessagePushUtil;
import com.ella.push.PushClient;
import com.ella.push.android.AndroidUnicast;
import com.ella.push.ios.IOSUnicast;

public class MessagePush {
    private String iosAppKey = MessagePushUtil.IOS_APPKEY.getType();
    private String androidAppKey = MessagePushUtil.ANDROID_APPKEY.getType();
    private String androidAppMasterSecret = MessagePushUtil.ANDROID_APPMASTERSECRET.getType();
    private String iosAppMasterSecret = MessagePushUtil.IOS_APPMASTERSECRET.getType();
    private PushClient client = new PushClient();

    public boolean sendAndroidUnicast(String deviceToken, JSONObject json) throws Exception {
        AndroidUnicast unicast = new AndroidUnicast(this.androidAppKey, this.androidAppMasterSecret);
        unicast.setDeviceToken(deviceToken);
        unicast.setTicker("Android unicast ticker");
        unicast.setTitle(json.getString("alert"));
        unicast.setText(json.getString("alert"));
        unicast.goAppAfterOpen();
        unicast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
        unicast.setCustomField(json.toString());
        unicast.setTestMode();
        unicast.setExtraField("test", "helloworld");
        return this.client.send(unicast);
    }

    public boolean sendIOSUnicast(String deviceToken, JSONObject json) throws Exception {
        IOSUnicast unicast = new IOSUnicast(this.iosAppKey, this.iosAppMasterSecret);
        unicast.setDeviceToken(deviceToken);
        unicast.setAlert(json.getString("alert"));
        unicast.setBadge(0);
        unicast.setContentAvailable(1);
        unicast.setSound("default");
        unicast.setTestMode();
        unicast.setCustomizedField("custom", json.toString());
        return this.client.send(unicast);
    }
}

