/*
 * Decompiled with CFR 0.152.
 */
package com.ella.aspect;

import com.alibaba.fastjson.JSONObject;
import com.ella.util.doc.DocEntity;
import com.ella.util.doc.DocFactory;
import com.ella.util.doc.annotations.DocConfig;
import com.ella.util.doc.enums.EllaProject;
import java.io.File;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

public class DocAspect {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected static String projectName;
    protected static EllaProject ellaProject;

    @Pointcut(value="@annotation(com.ella.util.doc.annotations.DocConfig)")
    public void docPointcut() {
    }

    @Around(value="docPointcut()")
    public Object Interceptor(ProceedingJoinPoint joinPoint) throws Throwable {
        Object response = joinPoint.proceed(joinPoint.getArgs());
        this.writeDoc(joinPoint, response);
        return response;
    }

    private void writeDoc(final ProceedingJoinPoint joinPoint, final Object response) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    JSONObject param;
                    String project = StringUtils.isNotBlank((CharSequence)projectName) ? projectName + File.separator : "";
                    Object obj = joinPoint.getTarget();
                    Class<?> clz = obj.getClass();
                    Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
                    DocConfig docConfig = method.getAnnotation(DocConfig.class);
                    if (DocAspect.this.expire(format.parse(docConfig.expireFlag()))) {
                        return;
                    }
                    Object o = joinPoint.getArgs().length < 1 ? "{}" : joinPoint.getArgs()[0];
                    if (o == null) {
                        o = "{}";
                    }
                    if (o instanceof String) {
                        try {
                            param = JSONObject.parseObject((String)o.toString());
                        }
                        catch (Exception e) {
                            param = new JSONObject();
                        }
                    } else {
                        param = JSONObject.parseObject((String)JSONObject.toJSONString((Object)o));
                    }
                    if (docConfig != null) {
                        DocEntity doc = docConfig.developer().get().setInfDesc(DocAspect.this.getNestedProperty(response, "remark")).setMethod(DocAspect.this.getNestedProperty(param, "publicParam.method"));
                        DocAspect.this.setErrorExample(docConfig, doc);
                        DocFactory docUtil = DocFactory.instance().setEllaProject(ellaProject).setParamAndResponse(param, response).setParamAndResponseClz(docConfig.VO(), docConfig.DTO()).setDocAndFileName(doc, project + clz.getTypeName() + File.separator + method.getName());
                        docUtil.create(docConfig.type());
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private boolean expire(Date expire) {
        Calendar cl = Calendar.getInstance();
        cl.set(12, 0);
        cl.set(13, 0);
        cl.add(10, -2);
        Date startTime = cl.getTime();
        cl.add(10, 4);
        Date endTime = cl.getTime();
        return expire.before(startTime) || expire.after(endTime);
    }

    private void setErrorExample(DocConfig docConfig, DocEntity doc) {
        String[] error = docConfig.error();
        if (error != null && error.length > 0) {
            for (int i = 0; i < error.length; ++i) {
                String[] split;
                if (!StringUtils.isNotBlank((CharSequence)error[i]) || (split = error[i].split(":")).length <= 1) continue;
                Map<String, String> map = doc.getErrorCodeAndMessage();
                map.put(split[0], split[1]);
            }
        }
    }

    public String getNestedProperty(Object object, String item) {
        try {
            return BeanUtils.getNestedProperty((Object)object, (String)item);
        }
        catch (Exception e) {
            return "";
        }
    }
}

