/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util.redisnew;

import com.ella.util.redisnew.ObjectCache;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.RedisTemplate;

public class SpringObjectRedisCache
implements ObjectCache {
    private RedisTemplate redisTemplate;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    SpringObjectRedisCache(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void expire(String key, Long expire) {
        this.redisTemplate.expire((Object)key, expire.longValue(), TimeUnit.SECONDS);
    }

    @Override
    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public void delete(String ... keys) {
        List collect = Arrays.stream(keys).filter(x -> StringUtils.isNotBlank((CharSequence)x)).collect(Collectors.toList());
        this.redisTemplate.delete(collect);
    }

    @Override
    public boolean haskey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    @Override
    public void lSet(String key, Object value) {
        this.redisTemplate.opsForList().leftPush((Object)key, value);
    }

    @Override
    public void lSet(String key, Object[] values) {
        this.redisTemplate.opsForList().leftPushAll((Object)key, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lGet(String key, Long index, Class<T> tClass) {
        T obj1 = null;
        try {
            Object obj2 = this.redisTemplate.opsForList().index((Object)key, index.longValue());
            if (null != obj2) {
                obj1 = tClass.newInstance();
                BeanUtils.copyProperties((Object)obj2, obj1);
            }
        }
        catch (Exception e) {
            this.logger.error("-----------------------------------run 4----------" + e.getMessage());
        }
        finally {
            return obj1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lGet(String key, Class<T> tClass) {
        T obj1 = null;
        try {
            Object obj2 = this.redisTemplate.opsForList().rightPop((Object)key);
            if (null != obj2) {
                obj1 = tClass.newInstance();
                BeanUtils.copyProperties((Object)obj2, obj1);
            }
        }
        catch (Exception e) {
            this.logger.error("-----------------------------------run 4----------" + e.getMessage());
        }
        finally {
            return obj1;
        }
    }

    @Override
    public void hSet(String key, String HashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)HashKey, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T hGet(String key, String HashKey, Class<T> tClass) {
        T obj1 = null;
        try {
            Object obj2 = this.redisTemplate.opsForHash().get((Object)key, (Object)HashKey);
            if (null != obj2) {
                obj1 = tClass.newInstance();
                BeanUtils.copyProperties((Object)obj2, obj1);
            }
        }
        catch (Exception e) {
            this.logger.error("-----------------------------------run 4----------" + e.getMessage());
        }
        finally {
            return obj1;
        }
    }

    @Override
    public void sSet(String key, Object ... values) {
        this.redisTemplate.opsForSet().add((Object)key, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T sGet(String key, Class<T> tClass) {
        T obj1 = null;
        try {
            Object obj2 = this.redisTemplate.opsForSet().pop((Object)key);
            if (null != obj2) {
                obj1 = tClass.newInstance();
                BeanUtils.copyProperties((Object)obj2, obj1);
            }
        }
        catch (Exception e) {
            this.logger.error("-----------------------------------run 4----------" + e.getMessage());
        }
        finally {
            return obj1;
        }
    }

    @Override
    public <T> Set<T> getSetkey(String key, Class<T> tClass) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    @Override
    public void sDelete(String key, Object ... values) {
        this.redisTemplate.opsForSet().remove((Object)key, values);
    }

    @Override
    public void zSet(String key, Object value) {
    }

    @Override
    public <T> T zGet(String key, Class<T> tClass) {
        return null;
    }
}

