/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util.redisnew;

import com.alibaba.fastjson.JSON;
import com.ella.util.redisnew.DistributedCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.SerializationUtils;

public class SpringDataRedisCache
implements DistributedCache {
    private StringRedisTemplate redisTemplate;

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public long decrByValue(String key, long value) {
        return this.redisTemplate.opsForValue().increment((Object)key, -value);
    }

    @Override
    public long decr(String key) {
        return this.redisTemplate.opsForValue().increment((Object)key, -1L);
    }

    @Override
    public long incrByValue(String key, long value) {
        return this.redisTemplate.opsForValue().increment((Object)key, value);
    }

    @Override
    public long incr(String key) {
        return this.redisTemplate.opsForValue().increment((Object)key, 1L);
    }

    @Override
    public void valueMultiSet(Map<String, Object> map) {
        Map<String, String> varsMap = this.objectMapToStringMap(map);
        this.redisTemplate.opsForValue().multiSet(varsMap);
    }

    private Map<String, String> objectMapToStringMap(Map<String, Object> map) {
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        HashMap<String, String> varsMap = new HashMap<String, String>();
        if (entrySet != null) {
            for (Map.Entry<String, Object> entry : entrySet) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                varsMap.put(key, value.toString());
            }
        }
        return varsMap;
    }

    @Override
    public List<String> batchGet(Collection<String> keys) {
        return this.redisTemplate.opsForValue().multiGet(keys);
    }

    @Override
    public List<String> batchGet(String[] keys) {
        ArrayList listKeys = new ArrayList();
        Collections.addAll(listKeys, keys);
        return this.redisTemplate.opsForValue().multiGet(listKeys);
    }

    @Override
    public List<String> batchGetLike(String pattern) {
        Set keys = this.redisTemplate.keys((Object)pattern);
        return this.redisTemplate.opsForValue().multiGet((Collection)keys);
    }

    @Override
    public Map<String, String> batchGetKV(Collection<String> keys) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        ArrayList<String> listKeys = new ArrayList<String>(keys);
        if (keys != null) {
            List<String> retList = this.batchGet(keys);
            int retSize = retList.size();
            for (int i = 0; i < retSize; ++i) {
                String key = (String)listKeys.get(i);
                String value = retList.get(i);
                retMap.put(key, value);
            }
        }
        return retMap;
    }

    @Override
    public Map<String, String> batchGetKV(String[] keys) {
        ArrayList<String> listKeys = new ArrayList<String>();
        Collections.addAll(listKeys, keys);
        return this.batchGetKV(listKeys);
    }

    @Override
    public Map<String, String> batchGetKVLike(String pattern) {
        Set keys = this.redisTemplate.keys((Object)pattern);
        return this.batchGetKV(keys);
    }

    @Override
    public void batchDelLike(String pattern) {
        Set keys = this.redisTemplate.keys((Object)pattern);
        this.batchDel(keys);
    }

    @Override
    public void batchDel(Collection<String> keys) {
        this.redisTemplate.delete(keys);
    }

    @Override
    public void del(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public boolean setObject2Bytes(final String key, Object value) {
        final byte[] bytesObject = SerializationUtils.serialize((Object)((Serializable)value));
        boolean result = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection conn) throws DataAccessException {
                conn.set(SpringDataRedisCache.this.redisTemplate.getStringSerializer().serialize((Object)key), bytesObject);
                return true;
            }
        }, false, true);
        return result;
    }

    @Override
    public boolean setObject2Json(final String key, Object value) {
        final String jsonObject = JSON.toJSONString((Object)value);
        boolean result = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection conn) throws DataAccessException {
                SpringDataRedisCache.this.redisTemplate.opsForValue().set((Object)key, (Object)jsonObject);
                return true;
            }
        }, false, true);
        return result;
    }

    @Override
    public <T> T getJsonObject(final String key, final Class<T> clazz) {
        return (T)this.redisTemplate.execute(new RedisCallback<T>(){

            public T doInRedis(RedisConnection conn) throws DataAccessException {
                Object value = null;
                String valueString = (String)SpringDataRedisCache.this.redisTemplate.opsForValue().get((Object)key);
                value = JSON.parseObject((String)valueString, (Class)clazz);
                return value;
            }
        });
    }

    @Override
    public <T> T getBytesObject(final String key) {
        return (T)this.redisTemplate.execute(new RedisCallback<T>(){

            public T doInRedis(RedisConnection conn) throws DataAccessException {
                Object value = null;
                byte[] keyBytes = SpringDataRedisCache.this.redisTemplate.getStringSerializer().serialize((Object)key);
                byte[] valueBytes = conn.get(keyBytes);
                if (valueBytes != null) {
                    value = SerializationUtils.deserialize((byte[])valueBytes);
                }
                return value;
            }
        });
    }

    @Override
    public void hashPut(String key, String hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
    }

    @Override
    public void hashPutAll(String key, Map<String, Object> hash) {
        this.redisTemplate.opsForHash().putAll((Object)key, hash);
    }

    @Override
    public Object hashGet(String key, Object hashKey) {
        return this.redisTemplate.opsForHash().get((Object)key, hashKey);
    }

    @Override
    public Map<String, Object> hashGetAll(final String key) {
        return (Map)this.redisTemplate.execute((RedisCallback)new RedisCallback<Map<String, Object>>(){

            public Map<String, Object> doInRedis(RedisConnection conn) throws DataAccessException {
                byte[] bytesKey = SpringDataRedisCache.this.redisTemplate.getStringSerializer().serialize((Object)key);
                Map bytesMap = conn.hGetAll(bytesKey);
                HashMap<String, Object> retMap = new HashMap<String, Object>();
                if (bytesMap != null) {
                    for (byte[] btKey : bytesMap.keySet()) {
                        byte[] byValue = (byte[])bytesMap.get(btKey);
                        retMap.put((String)SpringDataRedisCache.this.redisTemplate.getStringSerializer().deserialize(btKey), SpringDataRedisCache.this.redisTemplate.getStringSerializer().deserialize(byValue));
                    }
                }
                return retMap;
            }
        });
    }

    @Override
    public List<?> hashMultiGet(String key, Collection<Object> hashKeys) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, hashKeys);
    }

    @Override
    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)(value == null ? null : value.toString()));
    }

    @Override
    public void set(String key, Object value, int expire) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)String.valueOf(value), (long)expire, TimeUnit.SECONDS);
    }

    @Override
    public void setIfAbsent(String key, Object value) {
        this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)String.valueOf(value));
    }

    @Override
    public void setNX(String key, String value) {
        this.setIfAbsent(key, value);
    }

    @Override
    public boolean expireAt(String key, Date expire) {
        return this.redisTemplate.expireAt((Object)key, expire);
    }

    @Override
    public boolean expire(String key, long expire) {
        return this.redisTemplate.expire((Object)key, expire, TimeUnit.SECONDS);
    }

    @Override
    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public Integer getInt(String key) {
        String value = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return Integer.valueOf(value);
    }

    @Override
    public Float getFloat(String key) {
        String value = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return Float.valueOf(value);
    }

    @Override
    public void sendMessage(String topic, String message) {
        this.redisTemplate.convertAndSend(topic, (Object)message);
    }

    @Override
    public long getExpire(String key) {
        Long times = this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
        return times == null ? 0L : times;
    }
}

