/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util.excelUtil;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtils.class);
    private static final String XLS = "xls";
    private static final String XLSX = "xlsx";

    public static Map<String, Object> readExcel(MultipartFile file, String ... fileHead) {
        String checkHead;
        InputStream inputStream;
        Map<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("code", 300);
        try {
            inputStream = file.getInputStream();
        }
        catch (Exception e) {
            resultMap.put("errorMessage", "InputStream is null");
            return resultMap;
        }
        if (inputStream == null) {
            resultMap.put("errorMessage", "InputStream is null");
            return resultMap;
        }
        Map<String, Object> wbResult = ExcelUtils.getWorkbook(file, inputStream);
        if ((Integer)wbResult.get("code") != 200) {
            return wbResult;
        }
        Workbook wb = (Workbook)wbResult.get("result");
        if (fileHead != null && fileHead.length != 0 && StringUtils.isNotBlank((CharSequence)(checkHead = ExcelUtils.excelCheckHead(wb, fileHead)))) {
            resultMap.put("errorMessage", checkHead);
            return resultMap;
        }
        resultMap = ExcelUtils.excelReadData(wb, fileHead);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> getWorkbook(MultipartFile file, InputStream inputStream) {
        HSSFWorkbook wb = null;
        byte[] bufferIs = new byte[1024];
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("code", 301);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int len;
            while ((len = inputStream.read(bufferIs)) > -1) {
                byteArrayOutputStream.write(bufferIs, 0, len);
            }
            byteArrayOutputStream.flush();
        }
        catch (Exception e) {
            logger.error("create Workbook error:" + e.getMessage(), (Throwable)e);
            resultMap.put("errorMessage", e.getMessage());
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        finally {
            try {
                inputStream.close();
                byteArrayOutputStream.close();
            }
            catch (Exception e) {
                logger.error("close stream error:" + e.getMessage(), (Throwable)e);
            }
        }
        ByteArrayInputStream temp1 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String originalFilename = file.getOriginalFilename();
        try {
            if (originalFilename.endsWith(XLS)) {
                wb = new HSSFWorkbook((InputStream)temp1);
            } else if (originalFilename.endsWith(XLSX)) {
                wb = new XSSFWorkbook((InputStream)temp1);
            }
        }
        catch (Exception e) {
            logger.error("create HSSFWorkbook error:" + e.getMessage(), (Throwable)e);
            resultMap.put("code", 401);
            resultMap.put("errorMessage", "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u6309\u6a21\u677f\u586b\u5199\u4e0a\u4f20");
            try {
                wb = new XSSFWorkbook((InputStream)temp1);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                logger.error("create XSSFWorkbook error:" + e1.getMessage(), (Throwable)e1);
            }
        }
        finally {
            try {
                ((InputStream)temp1).close();
            }
            catch (Exception e) {
                logger.error("close ByteArrayInputStream error:" + e.getMessage(), (Throwable)e);
            }
        }
        if (wb == null) {
            return resultMap;
        }
        resultMap.put("code", 200);
        resultMap.put("result", wb);
        return resultMap;
    }

    private static String excelCheckHead(Workbook wb, String[] sheetHead) {
        Sheet sheet = wb.getSheetAt(0);
        Row row = sheet.getRow(0);
        if (!row.getCell(0).getStringCellValue().contains("\u8bf4\u660e")) {
            return "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u6309\u6a21\u677f\u586b\u5199\u4e0a\u4f20";
        }
        row = sheet.getRow(1);
        for (int i = 0; i < sheetHead.length; ++i) {
            if (row.getCell(i).getStringCellValue().equals(sheetHead[i])) continue;
            return "\u8868\u5934\u9519\u8bef\uff0c\u8bf7\u6309\u6a21\u677f\u586b\u5199\u4e0a\u4f20";
        }
        int sheetsNum = wb.getNumberOfSheets();
        for (int i = 1; i < sheetsNum; ++i) {
            int lastCellNum;
            sheet = wb.getSheetAt(i);
            if (sheet == null || sheet.getPhysicalNumberOfRows() <= 1) continue;
            row = sheet.getRow(0);
            for (lastCellNum = row.getLastCellNum(); lastCellNum > 0 && (row.getCell(lastCellNum - 1) == null || "".equals(row.getCell(lastCellNum - 1).toString().trim())); --lastCellNum) {
            }
            if (lastCellNum < sheetHead.length) {
                return sheet.getSheetName() + "\u5de5\u4f5c\u8868\u7684\u8868\u5934(\u7b2c\u4e00\u884c\u6570\u636e)\u4e0e\u8981\u6c42\u8868\u5934\u4e0d\u4e00\u81f4, \u7f3a\u5c11" + sheetHead[lastCellNum] + "\u5217";
            }
            for (String headStr : sheetHead) {
                boolean existFlag = false;
                for (Cell cell : row) {
                    if (!headStr.equals(cell.toString().trim())) continue;
                    existFlag = true;
                    break;
                }
                if (existFlag) continue;
                return sheet.getSheetName() + "\u5de5\u4f5c\u8868\u7684\u8868\u5934(\u7b2c\u4e00\u884c\u6570\u636e)\u4e0e\u8981\u6c42\u8868\u5934\u4e0d\u4e00\u81f4, \u7f3a\u5c11" + headStr + "\u5217";
            }
        }
        return null;
    }

    private static Map<String, Object> excelReadData(Workbook wb, String[] sheetHead) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>(16);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("code", 302);
        int sheetsNum = wb.getNumberOfSheets();
        for (int i = 0; i < sheetsNum; ++i) {
            Sheet sheet = wb.getSheetAt(i);
            if (sheet.getPhysicalNumberOfRows() <= 1) continue;
            if (sheetHead == null || sheetHead.length == 0) {
                sheetHead = ExcelUtils.excelSheetHead(sheet);
                if (sheetHead == null || sheetHead.length == 0) {
                    resultMap.put("errorMessage", sheet.getSheetName() + "\u5de5\u4f5c\u8868\u7684\u8868\u5934\u4fe1\u606f\u4e0d\u5b58\u5728");
                    return resultMap;
                }
                if (sheetHead[0] == null || "".equals(sheetHead[0].trim())) {
                    resultMap.put("errorMessage", sheet.getSheetName() + "\u5de5\u4f5c\u8868\u7684\u8868\u5934\u5b58\u5728\u7a7a\u5217, \u8bf7\u5904\u7406");
                    return resultMap;
                }
            }
            int temp = 2;
            for (int m = 2; m < sheet.getPhysicalNumberOfRows(); ++m) {
                int lastCellNum;
                JSONObject jsonObject = new JSONObject();
                Row row = sheet.getRow(temp);
                while (row == null) {
                    row = sheet.getRow(++temp);
                }
                for (lastCellNum = row.getLastCellNum(); lastCellNum > 0 && (row.getCell(lastCellNum - 1) == null || "".equals(row.getCell(lastCellNum - 1).toString().trim())); --lastCellNum) {
                }
                if (lastCellNum == 0) {
                    ++temp;
                    continue;
                }
                jsonObject.put("row", (Object)(++temp));
                jsonObject.put("sheet", (Object)sheet.getSheetName());
                for (Cell cell : row) {
                    if (cell == null || "".equals(cell.toString().trim())) continue;
                    jsonObject.put(cell.getColumnIndex() + "", (Object)String.valueOf(cell));
                }
                list.add(jsonObject);
            }
        }
        if (CollectionUtils.isEmpty(list)) {
            resultMap.put("errorMessage", "excel\u8868\u683c\u6ca1\u6709\u6570\u636e");
        } else {
            resultMap.put("code", 200);
            resultMap.put("result", list);
        }
        return resultMap;
    }

    private static String[] excelSheetHead(Sheet sheet) {
        int lastCellNum;
        if (sheet == null || sheet.getPhysicalNumberOfRows() < 1) {
            return null;
        }
        Row row = sheet.getRow(0);
        if (row == null || row.getPhysicalNumberOfCells() == 0) {
            return null;
        }
        int count = 0;
        for (Cell cell : row) {
            if (cell == null || "".equals(cell.toString().trim())) continue;
            ++count;
        }
        String[] head = new String[count];
        for (lastCellNum = row.getLastCellNum(); lastCellNum > 0 && (row.getCell(lastCellNum - 1) == null || "".equals(row.getCell(lastCellNum - 1).toString().trim())); --lastCellNum) {
        }
        if (lastCellNum == 0) {
            return null;
        }
        if (lastCellNum > head.length) {
            return head;
        }
        int i = 0;
        for (Cell cell : row) {
            if (cell == null || "".equals(cell.toString().trim())) continue;
            head[i++] = cell.toString().trim();
        }
        return head;
    }
}

