/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util.doc.impl;

import com.ella.util.doc.annotations.FieldExplain;
import com.ella.util.doc.enums.DocTypeAlias;
import com.ella.util.doc.inf.Table;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class TableFromClz
implements Table {
    List<String> list;
    String type;
    String groupId;
    String fieldName;
    Object fieldObj;
    String necessary;
    String docTypeAlias;
    String explain;

    public TableFromClz() {
    }

    public TableFromClz(List<String> list, String groupId, String type, String fieldName, Object fieldObj) {
        this.list = list;
        this.groupId = groupId;
        this.type = type;
        this.fieldName = fieldName;
        this.fieldObj = fieldObj;
    }

    @Override
    public void setTitle() {
        this.list.add("**" + this.fieldName + "\u8bf4\u660e\uff1a** ");
        this.list.add("");
        if ("param".equalsIgnoreCase(this.type)) {
            this.list.add("|\u53c2\u6570\u540d|\u5fc5\u9009|\u7c7b\u578b|\u8bf4\u660e|");
            this.list.add("|:----    |:---:|:---:|:-----   |");
            this.list.add("| ==========| ==== | ====|  ========================================  |");
        } else {
            this.list.add("|\u53c2\u6570\u540d|\u7c7b\u578b|\u8bf4\u660e|");
            this.list.add("|:----  |:-----: |:-----   |");
            this.list.add("| ==========| ==== | =====================================================  |");
        }
    }

    @Override
    public StringBuilder setElementTitle() {
        StringBuilder sb = new StringBuilder();
        if ("param".equalsIgnoreCase(this.type)) {
            sb.append("|").append(this.fieldName).append("|").append(this.necessary).append("|").append(this.docTypeAlias).append("|").append(this.explain).append("|");
        } else {
            sb.append("|").append(this.fieldName).append("|").append(this.docTypeAlias).append("|").append(this.explain).append("|");
        }
        return sb;
    }

    @Override
    public void create() throws Exception {
        LinkedHashMap objects = new LinkedHashMap();
        this.setTitle();
        if (this.fieldObj == null) {
            return;
        }
        Class<?> clz1 = this.fieldObj.getClass();
        List<Field> declaredFields = this.getClzFieldList(clz1);
        for (int i = 0; i < declaredFields.size(); ++i) {
            FieldExplain annotation = declaredFields.get(i).getAnnotation(FieldExplain.class);
            String string = this.groupId = StringUtils.isBlank((CharSequence)this.groupId) ? "default" : this.groupId;
            if (annotation == null || !ArrayUtils.contains((Object[])annotation.groups(), (Object)this.groupId)) continue;
            this.docTypeAlias = DocTypeAlias.getAlias(declaredFields.get(i).getType());
            this.fieldName = declaredFields.get(i).getName();
            this.necessary = annotation.necessary().getValue();
            this.explain = annotation.explain();
            StringBuilder sb = this.setElementTitle();
            this.list.add(sb.toString());
            if (!"array".equalsIgnoreCase(this.docTypeAlias) && !"object".equalsIgnoreCase(this.docTypeAlias)) continue;
            declaredFields.get(i).setAccessible(true);
            Type o = null;
            if (o == null) {
                o = declaredFields.get(i).getType();
            }
            if ("array".equalsIgnoreCase(this.docTypeAlias)) {
                ParameterizedType parameterizedType = (ParameterizedType)declaredFields.get(i).getGenericType();
                o = parameterizedType.getActualTypeArguments()[0];
            }
            o = o.newInstance();
            objects.put(declaredFields.get(i).getName(), (Class<?>)o);
        }
        this.list.add("");
        for (Map.Entry next : objects.entrySet()) {
            this.fieldName = (String)next.getKey();
            this.fieldObj = next.getValue();
            this.create();
        }
    }

    public List<Field> getClzFieldList(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        try {
            while (clazz != Object.class) {
                Field[] fields = clazz.getDeclaredFields();
                list.addAll(Arrays.asList(fields));
                clazz = clazz.getSuperclass();
            }
            list.forEach(s -> System.out.println(s.getName()));
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return list;
        }
    }
}

