/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util.doc;

import com.alibaba.fastjson.JSONObject;
import com.ella.util.FileUtil;
import com.ella.util.doc.DocClient;
import com.ella.util.doc.DocEntity;
import com.ella.util.doc.enums.DocPage;
import com.ella.util.doc.enums.EllaProject;
import com.ella.util.doc.enums.TableHelper;
import com.ella.util.doc.impl.DocImpl;
import com.ella.util.doc.impl.SampleImpl;
import com.ella.util.doc.impl.TableFromClz;
import com.ella.util.doc.impl.TableFromJson;
import com.ella.util.doc.inf.Doc;
import com.ella.util.doc.inf.Sample;
import com.ella.util.doc.inf.Table;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;

public class DocFactory {
    private Class<?> paramClass = Object.class;
    private Class<?> responseClass = Object.class;
    private Object param = "{}";
    private Object response = "{}";
    private DocEntity docEntity;
    private String fileName;
    private String remark;
    private String groupId;
    private List<String> list;
    private Doc doc;
    private Sample sample;
    private Table table;
    private DocPage docPage;
    private EllaProject ellaProject;

    public DocFactory setEllaProject(EllaProject ellaProject) {
        this.ellaProject = ellaProject;
        return this;
    }

    public static DocFactory instance() {
        return new DocFactory();
    }

    public DocFactory setParamAndResponseClz(Class<?> paramClass, Class<?> responseClass) {
        this.paramClass = paramClass == null ? this.paramClass : paramClass;
        this.responseClass = responseClass == null ? this.responseClass : responseClass;
        return this;
    }

    public <P, R> DocFactory setParamAndResponse(P param, R response) {
        this.param = param == null ? this.param : param;
        this.response = response == null ? this.response : response;
        try {
            this.remark = BeanUtils.getNestedProperty(response, (String)"remark");
        }
        catch (Exception e) {
            this.remark = "";
        }
        return this;
    }

    public DocFactory setDocAndFileName(DocEntity docEntity, String fileName) {
        this.docEntity = docEntity;
        this.fileName = fileName;
        return this;
    }

    public DocFactory setFieldGroups(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public void create(TableHelper tableType) throws Exception {
        this.create(DocImpl.class, tableType.getClz(), SampleImpl.class);
    }

    public void create(Class<? extends Doc> docClz, Class<? extends Table> tableClz, Class<? extends Sample> sampleClz) throws Exception {
        this.list = new LinkedList<String>();
        File file = FileUtil.createFile(".." + File.separator + "doc" + File.separator + this.fileName + ".txt", File.separator);
        this.createDoc(docClz);
        this.addTable(tableClz, "param", "\u4f20\u53c2");
        this.addSample(sampleClz, this.param, "\u4f20\u53c2");
        this.addTable(tableClz, "response", "\u8fd4\u53c2");
        this.addSample(sampleClz, this.response, "\u8fd4\u53c2");
        IOUtils.writeLines(this.list, (String)IOUtils.LINE_SEPARATOR, (OutputStream)new FileOutputStream(file), (String)"UTF-8");
        this.upload();
    }

    public void upload() throws Exception {
        DocPage docPage = this.docPage = this.docPage == null ? DocPage.ELLA_APP_PAGE : this.docPage;
        if (this.ellaProject == null || this.ellaProject.equals((Object)EllaProject.EMPTY)) {
            throw new RuntimeException("ellaProject id can't be null or empty!");
        }
        this.docPage.setItemId(this.ellaProject);
        StringBuilder sb = new StringBuilder();
        this.list.forEach(str -> sb.append(str + "\n"));
        this.docPage.setPageContent(URLEncoder.encode(sb.toString(), "UTF-8"));
        this.docPage.setPageTitle(this.remark);
        DocClient.uploadDoc(this.docPage);
    }

    public void createDoc(Class<? extends Doc> docClz) {
        if (docClz == DocImpl.class) {
            this.doc = new DocImpl(this.list, this.docEntity);
            this.doc.create();
        }
    }

    public void addSample(Class<? extends Sample> sampleClz, Object obj, String name) {
        if (sampleClz == SampleImpl.class) {
            this.sample = new SampleImpl(this.list, name, obj);
            this.sample.create();
        }
    }

    public void addTable(Class<? extends Table> tableClz, String type, String fieldName) throws Exception {
        Object obj;
        Class<?> clz = "param".equalsIgnoreCase(type) ? this.paramClass : this.responseClass;
        Object object = obj = "param".equalsIgnoreCase(type) ? this.param : this.response;
        if (tableClz == TableFromClz.class) {
            this.table = new TableFromClz(this.list, this.groupId, type, fieldName, clz.newInstance());
            this.table.create();
        }
        if (tableClz == TableFromJson.class) {
            this.table = new TableFromJson(this.list, this.groupId, type, fieldName, obj);
            this.table.create();
        }
    }

    private void setResponse() throws InstantiationException, IllegalAccessException {
        try {
            this.response = JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.response), this.responseClass);
        }
        catch (Exception e) {
            try {
                this.response = JSONObject.parseArray((String)JSONObject.toJSONString((Object)this.response), this.responseClass);
            }
            catch (Exception e1) {
                this.response = this.responseClass.newInstance();
            }
        }
    }

    public DocPage getDocPage() {
        return this.docPage;
    }

    public void setDocPage(DocPage docPage) {
        this.docPage = docPage;
    }
}

