/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util;

import com.ella.exception.EllaBookException;
import com.ella.response.ResponseParams;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class ExceptionMsgUtil {
    private static final FastDateFormat YYYY_MM_DD = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private static final String UNLIMIT_START_DATE = "2018-12-31";
    private static final long MILLISECOND_PER_DAY = 86400000L;

    public static void fillMsg(Exception e, ResponseParams<?> resp) {
        if (e instanceof EllaBookException) {
            resp.fillError(e.getMessage(), "5000040000");
        } else if (e instanceof ParseException) {
            resp.fillError("\u683c\u5f0f\u8f6c\u6362\u9519\u8bef", "5000040000");
        } else {
            resp.fillError("\u7cfb\u7edf\u9519\u8bef", "5000050000");
        }
    }

    public static void requireTrue(boolean check, String msg) {
        if (!check) {
            throw new EllaBookException(msg);
        }
    }

    public static void requireNonNull(Object obj, String msg) {
        ExceptionMsgUtil.requireTrue(Objects.nonNull(obj), msg);
    }

    public static void requireNotBlank(String str, String msg) {
        ExceptionMsgUtil.requireTrue(StringUtils.isNotBlank((CharSequence)str), msg);
    }

    public static void DateLimit(Date startTime, Date endTime, int days) {
        ExceptionMsgUtil.DateLimit(startTime, endTime, days, false);
    }

    public static void DateLimit(Date startTime, Date endTime, int days, boolean unlimitByStartTime) {
        if (!ObjectUtils.allNotNull((Object[])new Object[]{startTime, endTime})) {
            throw new EllaBookException("\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (days < 1) {
            return;
        }
        if (unlimitByStartTime && UNLIMIT_START_DATE.equals(YYYY_MM_DD.format(startTime))) {
            return;
        }
        if (endTime.getTime() - startTime.getTime() > (long)days * 86400000L) {
            throw new EllaBookException("\u67e5\u8be2\u65f6\u95f4\u6bb5\u8fc7\u957f");
        }
    }

    public static void requireTrueWithResponse(boolean check, String msg) {
        if (!check) {
            ResponseParams error = new ResponseParams();
            error.fillError(msg, "50000000");
            throw new EllaBookException(error);
        }
    }

    public static void requireNotBlankWithResponse(String str, String msg) {
        ExceptionMsgUtil.requireTrueWithResponse(StringUtils.isNotBlank((CharSequence)str), msg);
    }
}

