/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static String DEFAULT_BEGIN_TIME = " 00:00:00";
    public static String DEFAULT_END_TIME = " 23:59:59";

    public static String dateToString(Date date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String dateToString(Date date) {
        return DateUtil.dateToString(date, DEFAULT_FORMAT);
    }

    public static Date stringToDate(String date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date stringToDate(String date) {
        return DateUtil.stringToDate(date, DEFAULT_FORMAT);
    }

    public static Integer leftTime(Date date) {
        Long beginTimes = DateUtil.dateConvert(new Date(), DEFAULT_BEGIN_TIME);
        Long endTimes = DateUtil.dateConvert(date, DEFAULT_END_TIME);
        Long leftTime = (endTimes - beginTimes) / 1000L / 60L / 60L;
        leftTime = leftTime % 24L == 0L ? Long.valueOf(leftTime / 24L) : Long.valueOf(leftTime / 24L + 1L);
        return Integer.valueOf(String.valueOf(leftTime));
    }

    public static Long dateConvert(Date date, String endTime) {
        String dateStr = DateUtil.dateToString(date, DEFAULT_DATE_FORMAT) + endTime;
        Date nowDate = DateUtil.stringToDate(dateStr);
        System.out.println(dateStr);
        System.out.println(nowDate.getTime());
        return nowDate.getTime();
    }

    public static Date todayLastTime() {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_FORMAT);
        LocalDate today = LocalDate.now();
        Date dat = new Date();
        String dateStr = today + DEFAULT_END_TIME;
        Date nowDate = null;
        try {
            nowDate = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return nowDate;
    }

    public static int getIntervalDay(Date tar) {
        int ret = -1;
        Calendar calNow = Calendar.getInstance();
        if (null != tar && tar.before(calNow.getTime())) {
            Calendar calTar = Calendar.getInstance();
            calTar.setTime(tar);
            long millisNow = calNow.getTimeInMillis();
            long millisTar = tar.getTime();
            if (millisTar < millisNow) {
                ret = (int)((millisNow - millisTar) / 86400000L);
            }
        }
        return ret;
    }

    public static String getLastMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        return format.format(calendar.getTime());
    }

    public static String getLastMonth(String month) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(format.parse(month));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        calendar.add(2, -1);
        return format.format(calendar.getTime());
    }

    public static Date getLastDay(Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static String getTodayDateStr() {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        return format.format(new Date());
    }

    public static String getNextDay(String day, int n) {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(sdf.parse(day));
            calendar.add(5, n);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String tomorrow = sdf.format(calendar.getTime());
        return tomorrow;
    }

    public static Date[] getFirstAndLastOfWeek(Date data) {
        Date[] dates = new Date[2];
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        int d = 0;
        d = cal.get(7) == 1 ? -6 : 2 - cal.get(7);
        cal.add(7, d);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        SimpleDateFormat sdf2 = new SimpleDateFormat(DEFAULT_FORMAT);
        String dateS = sdf.format(cal.getTime());
        try {
            dates[0] = sdf.parse(dateS);
            cal.add(7, 6);
            dateS = sdf1.format(cal.getTime());
            dates[1] = sdf2.parse(dateS);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return dates;
    }

    public static Date getLastdayOfMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        SimpleDateFormat sdf1 = new SimpleDateFormat(DEFAULT_FORMAT);
        Calendar ca = Calendar.getInstance();
        try {
            ca.setTime(date);
            ca.set(5, 1);
            ca.add(2, 1);
            ca.add(5, -1);
            String dateS = sdf.format(ca.getTime());
            return sdf1.parse(dateS);
        }
        catch (ParseException e) {
            return ca.getTime();
        }
    }

    public static Date getFirstdayOfMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, 1);
        try {
            String dateS = sdf.format(ca.getTime());
            return sdf.parse(dateS);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return ca.getTime();
        }
    }

    public static Date getFirstdayOfNextMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, 1);
        ca.add(2, 1);
        try {
            String dateS = sdf.format(ca.getTime());
            return sdf.parse(dateS);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return ca.getTime();
        }
    }

    public static long daysBetweenNew(Date before, Date after) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(before);
        long time1 = cal.getTimeInMillis();
        cal.setTime(after);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Math.abs(between_days);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        String dateString2;
        String dateString1 = DateUtil.dateToString(date1, "yyyy-MM-dd");
        return StringUtils.equalsIgnoreCase((CharSequence)dateString1, (CharSequence)(dateString2 = DateUtil.dateToString(date2, "yyyy-MM-dd")));
    }

    public static Date plusDay(int num, Date newDate) {
        try {
            Calendar ca = Calendar.getInstance();
            ca.setTime(newDate);
            ca.add(5, num);
            newDate = ca.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return newDate;
    }

    public static String getYearString() {
        Date date = new Date();
        SimpleDateFormat yyyy = new SimpleDateFormat("yyyy");
        String format = yyyy.format(date);
        return format;
    }

    private static boolean isThisTime(Date date, String pattern) {
        String now;
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String param = sdf.format(date);
        return param.equals(now = sdf.format(new Date()));
    }

    public static String dateToMonth(Date date) {
        if (DateUtil.isNow(date)) {
            return "\u4eca\u5929";
        }
        boolean thisTime = DateUtil.isThisTime(date, "yyyy-MM");
        if (thisTime) {
            return "\u672c\u6708";
        }
        boolean yyyy = DateUtil.isThisTime(date, "yyyy");
        if (yyyy) {
            String s = DateUtil.getDataMonth(date);
            return s + "\u6708";
        }
        String dataYear = DateUtil.getDataYear(date);
        SimpleDateFormat sdf = new SimpleDateFormat("MM");
        String format = sdf.format(date);
        return dataYear + "\u5e74" + format + "\u6708";
    }

    private static boolean isNow(Date date) {
        Date now = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        String nowDay = sf.format(now);
        String day = sf.format(date);
        return day.equals(nowDay);
    }

    public static String dateFormat(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static String dateFormatyyyyMMdd(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(date);
    }

    public static String dateFormatStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return format.format(date);
    }

    public static Date getDate(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date perseDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return format.parse(format.format(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String addCalendarStr(String startTimeStr, Integer feild, Integer amount) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date endTime = null;
        try {
            Date startTime = format.parse(startTimeStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            calendar.add(feild, amount);
            endTime = calendar.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return format.format(endTime);
    }

    public static String formatConvert(String dateStr, String formatStr, String format2Str) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        SimpleDateFormat format2 = new SimpleDateFormat(format2Str);
        Date date = null;
        try {
            date = format.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return format2.format(date);
    }

    public static Integer getDaysOfDatesStr(String startDate, String endDate, String formatStr) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        Integer days = 0;
        try {
            Date start = format.parse(startDate);
            Date end = format.parse(endDate);
            days = (int)((end.getTime() - start.getTime()) / 86400000L);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static String getNextDay(String date, Integer subDay) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(format.parse(date));
            c.add(5, subDay);
            Date tomorrow = c.getTime();
            return format.format(tomorrow);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getNextDayWithYYYYMMDD(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(format.parse(date));
            c.add(5, 1);
            Date tomorrow = c.getTime();
            return format.format(tomorrow);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getCNDayOfWeek(int i) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 7);
        map.put(2, 1);
        map.put(3, 2);
        map.put(4, 3);
        map.put(5, 4);
        map.put(6, 5);
        map.put(7, 6);
        return (Integer)map.get(i);
    }

    public static String getDataYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1) + "";
    }

    public static String getDataMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2) + 1 + "";
    }

    public static String getDataDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5) + "";
    }

    public static String getDateHour(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(11) + "";
    }

    public static long getLongOfEarlierDate(Date start, Date end) {
        if (start.getTime() > end.getTime()) {
            return end.getTime();
        }
        return start.getTime();
    }

    public static long getLongOfLaterDate(Date start, Date end) {
        if (start.getTime() < end.getTime()) {
            return end.getTime();
        }
        return start.getTime();
    }

    public static Date getFisrtDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        return cal.getTime();
    }

    public static String dateToWeek(Date datetime) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        String str = f.format(datetime);
        String[] weekDays = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
        Calendar cal = Calendar.getInstance();
        Date datet = null;
        try {
            datet = f.parse(str);
            cal.setTime(datet);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return str + " " + weekDays[w];
    }

    public static String weekOfDay(Date datetime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(datetime);
        String[] weekDays = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static Date getDayEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        return calendar.getTime();
    }

    public static Date getDayStartTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        return calendar.getTime();
    }

    public static Date getDayStartTimeForMilliSecond(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.CHINA);
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), 0, 0, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime();
    }

    public static List<Date> getPreAndCurrentZeroOClock(Date date) {
        ArrayList dateResult = Lists.newArrayList((Object[])new Date[]{null, null});
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        dateResult.set(1, calendar.getTime());
        calendar.add(6, -1);
        dateResult.set(0, calendar.getTime());
        return dateResult;
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static boolean isDiffMonth(String date1, String date2) {
        return DateUtil.isDiffMonth(DateUtil.stringToDate(date1, DEFAULT_DATE_FORMAT), DateUtil.stringToDate(date2, DEFAULT_DATE_FORMAT));
    }

    public static boolean isDiffMonth(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return calendar1.get(1) == calendar2.get(1) && calendar1.get(2) == calendar2.get(2);
    }

    public static Integer getDifMonth(String startDate, String endDate) {
        return DateUtil.getDifMonth(DateUtil.stringToDate(startDate, DEFAULT_DATE_FORMAT), DateUtil.stringToDate(endDate, DEFAULT_DATE_FORMAT));
    }

    public static Integer getDifMonth(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        int result = end.get(2) - start.get(2);
        int month = (end.get(1) - start.get(1)) * 12;
        return Math.abs(month + result);
    }

    public static String dateFormatOfMMdd(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("MM\u6708dd\u65e5");
        return format.format(date);
    }

    public static String getScheduleActiveDate(Date scheduleTimeBegin, Integer count) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date today = scheduleTimeBegin;
        Date tomorrow = null;
        int delay = 1;
        int num = count;
        while (delay <= num) {
            tomorrow = DateUtil.getTomorrow(today);
            if (!DateUtil.isWeekend(tomorrow)) {
                ++delay;
                today = tomorrow;
                continue;
            }
            if (!DateUtil.isWeekend(tomorrow)) continue;
            today = tomorrow;
        }
        return sdf.format(today);
    }

    public static Date getTomorrow(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        date = calendar.getTime();
        return date;
    }

    public static boolean isWeekend(Date sdate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdate);
        return cal.get(7) == 7 || cal.get(7) == 1;
    }

    public static int compareDateStr(String dateStr1, String dateStr2) {
        Date date1 = DateUtil.stringToDate(dateStr1, "yyyyMMdd");
        Date date2 = DateUtil.stringToDate(dateStr2, "yyyyMMdd");
        return date1.compareTo(date2);
    }

    public static boolean isDateStrBetweenStartAndEndDate(String dateStr, String startDate, String endDate) {
        Date date = DateUtil.stringToDate(dateStr, "yyyyMMdd");
        Date date1 = DateUtil.stringToDate(startDate, "yyyyMMdd");
        Date date2 = DateUtil.stringToDate(endDate, "yyyyMMdd");
        return date.compareTo(date1) >= 0 && date.compareTo(date2) <= 0;
    }

    public static Date getBeginTimeOfDate(Date date) {
        Long beginTimes = DateUtil.dateConvert(date, DEFAULT_BEGIN_TIME);
        return new Date(beginTimes);
    }

    public static Date getEndTimeOfDate(Date date) {
        Long beginTimes = DateUtil.dateConvert(date, DEFAULT_END_TIME);
        return new Date(beginTimes);
    }

    public static boolean isGreaterThanDayOfDatePeriod(String startDate, String endDate, int day) {
        Date date = DateUtil.stringToDate(startDate, "yyyyMMdd");
        Date date1 = DateUtil.stringToDate(endDate, "yyyyMMdd");
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(date);
        ((Calendar)cal1).add(5, day);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(date1);
        return cal2.compareTo(cal1) == 1;
    }

    public static String dateFormatyyyyMM(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        return format.format(date);
    }

    public static Integer getDayBetweenNum(String startDate, String endDate) {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        Integer dayNum = 0;
        try {
            if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
                Date start = format.parse(startDate);
                Date end = format.parse(endDate);
                dayNum = (int)((end.getTime() - start.getTime()) / 86400000L);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dayNum;
    }

    public static boolean requireTwoDateInANum(String startDate, String endDate, int day) {
        return DateUtil.getDayBetweenNum(startDate, endDate) >= 0 && DateUtil.getDayBetweenNum(startDate, endDate) <= day;
    }

    public static Date getDateAfterDays(Date date, long days) {
        Calendar calendar = Calendar.getInstance();
        long time = date.getTime();
        calendar.setTimeInMillis(time + days * 1000L * 60L * 60L * 24L);
        return DateUtil.getBeginTimeOfDate(calendar.getTime());
    }

    public static Date getDateAfterSeconds(Date date, long seconds) {
        Calendar calendar = Calendar.getInstance();
        long time = date.getTime();
        calendar.setTimeInMillis(time + seconds * 1000L);
        return calendar.getTime();
    }

    public static long getTimeToTodayEnd() {
        Calendar calendar = Calendar.getInstance();
        long now = calendar.getTimeInMillis();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        long end = calendar.getTimeInMillis();
        return (end - now) / 1000L;
    }
}

