/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util;

import java.math.BigDecimal;
import java.util.Objects;

public class BigDecimalUtil {
    private static final int DEF_DIV_SCALE = 10;
    public static final int DEF_SCALE = 4;

    private BigDecimalUtil() {
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static BigDecimal add(BigDecimal v1, BigDecimal v2, int scale) {
        if (Objects.isNull(v1)) {
            v1 = BigDecimal.ZERO;
        }
        if (Objects.isNull(v2)) {
            v2 = BigDecimal.ZERO;
        }
        return v1.add(v2).setScale(scale, 4);
    }

    public static BigDecimal add(BigDecimal v1, BigDecimal v2) {
        return BigDecimalUtil.add(v1, v2, 4);
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static BigDecimal sub(BigDecimal v1, BigDecimal v2, int scale) {
        if (Objects.isNull(v1) || Objects.isNull(v2)) {
            return null;
        }
        return v1.subtract(v2).setScale(scale, 4);
    }

    public static BigDecimal sub(BigDecimal v1, BigDecimal v2) {
        return BigDecimalUtil.sub(v1, v2, 4);
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static BigDecimal mul(BigDecimal v1, BigDecimal v2, int scale) {
        if (Objects.isNull(v1) || Objects.isNull(v2)) {
            return null;
        }
        return v1.multiply(v2).setScale(scale, 4);
    }

    public static BigDecimal mul(BigDecimal v1, BigDecimal v2) {
        return BigDecimalUtil.mul(v1, v2, 4);
    }

    public static double div(double v1, double v2) {
        return BigDecimalUtil.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static BigDecimal div(BigDecimal v1, BigDecimal v2, int scale) {
        if (Objects.isNull(v1) || Objects.isNull(v2)) {
            return null;
        }
        return v1.divide(v2, scale, 4);
    }

    public static BigDecimal div(BigDecimal v1, BigDecimal v2) {
        return BigDecimalUtil.div(v1, v2, 4);
    }
}

