/*
 * Decompiled with CFR 0.152.
 */
package com.ella.constraint.inf.impl;

import com.ella.constraint.annotation.DefaultDate;
import com.ella.constraint.inf.SetDefault;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.validation.ConstraintViolation;
import org.apache.commons.lang3.StringUtils;

public class SetDefaultDate
implements SetDefault<DefaultDate, Date> {
    @Override
    public <B> void setDefault(ConstraintViolation<B> tConstraintViolation, DefaultDate annotation) throws Exception {
        SimpleDateFormat dateFormat = null;
        String format = annotation.format().trim();
        String value = annotation.value().trim();
        Date date = (Date)this.invokeGetFieldValue(tConstraintViolation);
        if (StringUtils.isNotBlank((CharSequence)format)) {
            dateFormat = new SimpleDateFormat(format);
        }
        if (dateFormat != null && StringUtils.isNotBlank((CharSequence)value)) {
            date = dateFormat.parse(value);
        }
        if (date == null) {
            date = new Date();
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        this.setDateTime(annotation, cl);
        this.addDateTime(annotation, cl);
        this.setTimeZone(annotation, cl);
        if (dateFormat != null) {
            dateFormat.parse(dateFormat.format(cl.getTime()));
        }
        this.invokeSetFieldValue(tConstraintViolation, cl.getTime());
    }

    @Override
    public Class<DefaultDate> getAnnotation() {
        return DefaultDate.class;
    }

    public void afterPropertiesSet() throws Exception {
    }

    private void setTimeZone(DefaultDate annotation, Calendar cl) {
        if (annotation.ZONE_OFFSET() > 0) {
            cl.add(15, annotation.ZONE_OFFSET());
        }
    }

    private void addDateTime(DefaultDate annotation, Calendar cl) {
        if (annotation.ADD_YEAR() != 0) {
            cl.add(1, annotation.ADD_YEAR());
        }
        if (annotation.ADD_MONTH() != 0) {
            cl.add(2, annotation.ADD_MONTH());
        }
        if (annotation.ADD_WEEK_OF_MONTH() != 0) {
            cl.add(4, annotation.ADD_WEEK_OF_MONTH());
        }
        if (annotation.ADD_WEEK_OF_YEAR() != 0) {
            cl.add(3, annotation.ADD_WEEK_OF_YEAR());
        }
        if (annotation.ADD_DATE() != 0) {
            cl.add(5, annotation.ADD_DATE());
        }
        if (annotation.ADD_DAY_OF_WEEK() != 0) {
            cl.add(2, annotation.ADD_MONTH());
        }
        if (annotation.ADD_DAY_OF_WEEK_IN_MONTH() != 0) {
            cl.add(8, annotation.ADD_DAY_OF_WEEK_IN_MONTH());
        }
        if (annotation.ADD_DAY_OF_MONTH() != 0) {
            cl.add(5, annotation.ADD_DAY_OF_MONTH());
        }
        if (annotation.ADD_DAY_OF_YEAR() != 0) {
            cl.add(6, annotation.ADD_DAY_OF_WEEK());
        }
        if (annotation.ADD_HOUR() != 0) {
            cl.add(10, annotation.ADD_HOUR());
        }
        if (annotation.ADD_HOUR_OF_DAY() != 0) {
            cl.add(11, annotation.ADD_HOUR_OF_DAY());
        }
        if (annotation.ADD_MINUTE() != 0) {
            cl.add(12, annotation.MINUTE());
        }
        if (annotation.ADD_SECOND() != 0) {
            cl.add(13, annotation.ADD_SECOND());
        }
        if (annotation.ADD_MILLISECOND() != 0) {
            cl.add(14, annotation.ADD_MILLISECOND());
        }
    }

    private void setDateTime(DefaultDate annotation, Calendar cl) {
        if (annotation.YEAR() > 0) {
            cl.set(1, annotation.YEAR());
        }
        if (annotation.MONTH() > 0) {
            cl.set(2, annotation.MONTH());
        }
        if (annotation.WEEK_OF_MONTH() > 0) {
            cl.set(4, annotation.WEEK_OF_MONTH());
        }
        if (annotation.WEEK_OF_YEAR() > 0) {
            cl.set(3, annotation.WEEK_OF_YEAR());
        }
        if (annotation.DATE() > 0) {
            cl.set(5, annotation.DATE());
        }
        if (annotation.DAY_OF_MONTH() > 0) {
            cl.set(5, annotation.DAY_OF_MONTH());
        }
        if (annotation.DAY_OF_WEEK() > 0) {
            cl.set(7, annotation.DAY_OF_WEEK());
        }
        if (annotation.DAY_OF_WEEK_IN_MONTH() > 0) {
            cl.set(8, annotation.DAY_OF_WEEK_IN_MONTH());
        }
        if (annotation.DAY_OF_YEAR() > 0) {
            cl.set(6, annotation.DAY_OF_YEAR());
        }
        if (annotation.HOUR() > 0) {
            cl.set(10, annotation.HOUR());
        }
        if (annotation.HOUR_OF_DAY() > 0) {
            cl.set(11, annotation.HOUR_OF_DAY());
        }
        if (annotation.SECOND() > 0) {
            cl.set(13, annotation.SECOND());
        }
        if (annotation.MINUTE() > 0) {
            cl.set(12, annotation.MINUTE());
        }
        if (annotation.MILLISECOND() > 0) {
            cl.set(14, annotation.MILLISECOND());
        }
    }
}

