/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.boot;

import com.frameworkset.util.SimpleStringUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseESProperties {
    private String name;
    private String elasticUser;
    private String elasticPassword;
    private Elasticsearch elasticsearch;
    private Http http;
    private Db db;
    private Ip ip;
    private Dslfile dslfile;

    public Ip getIp() {
        return this.ip;
    }

    public void setIp(Ip ip) {
        this.ip = ip;
    }

    public Dslfile getDslfile() {
        return this.dslfile;
    }

    public void setDslfile(Dslfile dslfile) {
        this.dslfile = dslfile;
    }

    public Http getHttp() {
        return this.http;
    }

    public void setHttp(Http http) {
        this.http = http;
    }

    public Db getDb() {
        return this.db;
    }

    public void setDb(Db db) {
        this.db = db;
    }

    public String getElasticUser() {
        return this.elasticUser;
    }

    public void setElasticUser(String elasticUser) {
        this.elasticUser = elasticUser;
    }

    public String getElasticPassword() {
        return this.elasticPassword;
    }

    public void setElasticPassword(String elasticPassword) {
        this.elasticPassword = elasticPassword;
    }

    public Elasticsearch getElasticsearch() {
        return this.elasticsearch;
    }

    public void setElasticsearch(Elasticsearch elasticsearch) {
        this.elasticsearch = elasticsearch;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map buildProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String _name = "";
        if (SimpleStringUtil.isNotEmpty((String)this.name)) {
            properties.put("elasticsearch.serverNames", this.name);
            _name = this.name + ".";
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticUser)) {
            properties.put(_name + "elasticUser", this.elasticUser);
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticPassword)) {
            properties.put(_name + "elasticPassword", this.elasticPassword);
        }
        if (this.getElasticsearch() != null) {
            if (this.getElasticsearch().getRest() != null && SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getRest().getHostNames())) {
                properties.put(_name + "elasticsearch.rest.hostNames", this.getElasticsearch().getRest().getHostNames());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getDateFormat())) {
                properties.put(_name + "elasticsearch.dateFormat", this.getElasticsearch().getDateFormat());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getTimeZone())) {
                properties.put(_name + "elasticsearch.timeZone", this.getElasticsearch().getTimeZone());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getTtl())) {
                properties.put(_name + "elasticsearch.ttl", this.getElasticsearch().getTtl());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getShowTemplate())) {
                properties.put(_name + "elasticsearch.showTemplate", this.getElasticsearch().getShowTemplate());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getDiscoverHost())) {
                properties.put(_name + "elasticsearch.discoverHost", this.getElasticsearch().getDiscoverHost());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getSliceScrollThreadCount())) {
                properties.put(_name + "elasticsearch.sliceScrollThreadCount", this.getElasticsearch().getSliceScrollThreadCount());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getSliceScrollThreadQueue())) {
                properties.put(_name + "elasticsearch.sliceScrollThreadQueue", this.getElasticsearch().getSliceScrollThreadQueue());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getSliceScrollBlockedWaitTimeout())) {
                properties.put(_name + "elasticsearch.sliceScrollBlockedWaitTimeout", this.getElasticsearch().getSliceScrollBlockedWaitTimeout());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getScrollThreadCount())) {
                properties.put(_name + "elasticsearch.scrollThreadCount", this.getElasticsearch().getScrollThreadCount());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getScrollThreadQueue())) {
                properties.put(_name + "elasticsearch.scrollThreadQueue", this.getElasticsearch().getScrollThreadQueue());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getScrollBlockedWaitTimeout())) {
                properties.put(_name + "elasticsearch.scrollBlockedWaitTimeout", this.getElasticsearch().getScrollBlockedWaitTimeout());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getIncludeTypeName())) {
                properties.put(_name + "elasticsearch.includeTypeName", this.getElasticsearch().getIncludeTypeName());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getHealthCheckInterval())) {
                properties.put(_name + "elasticsearch.healthCheckInterval", this.getElasticsearch().getHealthCheckInterval());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getSlowDslThreshold())) {
                properties.put(_name + "elasticsearch.slowDslThreshold", this.getElasticsearch().getSlowDslThreshold());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getSlowDslCallback())) {
                properties.put(_name + "elasticsearch.slowDslCallback", this.getElasticsearch().getSlowDslCallback());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getUseHttps())) {
                properties.put(_name + "elasticsearch.useHttps", this.getElasticsearch().getUseHttps());
            }
        }
        if (this.getHttp() != null) {
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getTimeoutConnection())) {
                properties.put(_name + "http.timeoutConnection", this.getHttp().getTimeoutConnection());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.elasticUser)) {
                properties.put(_name + "http.authAccount", this.elasticUser);
            }
            if (SimpleStringUtil.isNotEmpty((String)this.elasticPassword)) {
                properties.put(_name + "http.authPassword", this.elasticPassword);
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getTimeoutSocket())) {
                properties.put(_name + "http.timeoutSocket", this.getHttp().getTimeoutSocket());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getConnectionRequestTimeout())) {
                properties.put(_name + "http.connectionRequestTimeout", this.getHttp().getConnectionRequestTimeout());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getAutomaticRetriesDisabled())) {
                properties.put(_name + "http.automaticRetriesDisabled", this.getHttp().getAutomaticRetriesDisabled());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getBackoffAuth())) {
                properties.put(_name + "http.backoffAuth", this.getHttp().getBackoffAuth());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getEncodedAuthCharset())) {
                properties.put(_name + "http.encodedAuthCharset", this.getHttp().getEncodedAuthCharset());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getRetryTime())) {
                properties.put(_name + "http.retryTime", this.getHttp().getRetryTime());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getRetryInterval())) {
                properties.put(_name + "http.retryInterval", this.getHttp().getRetryInterval());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getMaxLineLength())) {
                properties.put(_name + "http.maxLineLength", this.getHttp().getMaxLineLength());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getMaxHeaderCount())) {
                properties.put(_name + "http.maxHeaderCount", this.getHttp().getMaxHeaderCount());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getMaxTotal())) {
                properties.put(_name + "http.maxTotal", this.getHttp().getMaxTotal());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getDefaultMaxPerRoute())) {
                properties.put(_name + "http.defaultMaxPerRoute", this.getHttp().getDefaultMaxPerRoute());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getSoReuseAddress())) {
                properties.put(_name + "http.soReuseAddress", this.getHttp().getSoReuseAddress());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getSoKeepAlive())) {
                properties.put(_name + "http.soKeepAlive", this.getHttp().getSoKeepAlive());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getTimeToLive())) {
                properties.put(_name + "http.timeToLive", this.getHttp().getTimeToLive());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getKeepAlive())) {
                properties.put(_name + "http.keepAlive", this.getHttp().getKeepAlive());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getKeystore())) {
                properties.put(_name + "http.keystore", this.getHttp().getKeystore());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getKeyPassword())) {
                properties.put(_name + "http.keyPassword", this.getHttp().getKeyPassword());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getHostnameVerifier())) {
                properties.put(_name + "http.hostnameVerifier", this.getHttp().getHostnameVerifier());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getValidateAfterInactivity())) {
                properties.put(_name + "http.validateAfterInactivity", this.getHttp().getValidateAfterInactivity());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().isStaleConnectionCheckEnabled())) {
                properties.put(_name + "http.staleConnectionCheckEnabled", this.getHttp().isStaleConnectionCheckEnabled());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getCustomHttpRequestRetryHandler())) {
                properties.put(_name + "http.customHttpRequestRetryHandler", this.getHttp().getCustomHttpRequestRetryHandler());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getEvictExpiredConnections())) {
                properties.put(_name + "http.evictExpiredConnections", this.getHttp().getEvictExpiredConnections());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getKeystoreAlias())) {
                properties.put(_name + "http.keystoreAlias", this.getHttp().getKeystoreAlias());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getTrustAlias())) {
                properties.put(_name + "http.trustAlias", this.getHttp().getTrustAlias());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getSupportedProtocols())) {
                properties.put(_name + "http.supportedProtocols", this.getHttp().getSupportedProtocols());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getTruststore())) {
                properties.put(_name + "http.truststore", this.getHttp().getTruststore());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getTrustPassword())) {
                properties.put(_name + "http.trustPassword", this.getHttp().getTrustPassword());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getHttpClientBuilderCallback())) {
                properties.put(_name + "http.httpClientBuilderCallback", this.getHttp().getHttpClientBuilderCallback());
            }
        }
        if (this.dslfile != null) {
            properties.put("dslfile.refreshInterval", this.dslfile.getRefreshInterval());
            if (this.dslfile.getDslMappingDir() != null && !this.dslfile.getDslMappingDir().trim().equals("")) {
                properties.put("dslfile.dslMappingDir", this.dslfile.getDslMappingDir());
            }
        }
        if (this.ip != null) {
            if (SimpleStringUtil.isNotEmpty((String)this.ip.getDatabase())) {
                properties.put("ip.database", this.ip.getDatabase());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.ip.getAsnDatabase())) {
                properties.put("ip.asnDatabase", this.ip.getAsnDatabase());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.ip.getCachesize())) {
                properties.put("ip.cachesize", this.ip.getCachesize());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.ip.getServiceUrl())) {
                properties.put("ip.serviceUrl", this.ip.getServiceUrl());
            }
        }
        return properties;
    }

    public static class Rest {
        private String hostNames;

        public String getHostNames() {
            return this.hostNames;
        }

        public void setHostNames(String hostNames) {
            this.hostNames = hostNames;
        }
    }

    public static class Dslfile {
        private String refreshInterval;
        private String dslMappingDir;

        public String getRefreshInterval() {
            return this.refreshInterval;
        }

        public void setRefreshInterval(String refreshInterval) {
            this.refreshInterval = refreshInterval;
        }

        public void setDslMappingDir(String dslMappingDir) {
            this.dslMappingDir = dslMappingDir;
        }

        public String getDslMappingDir() {
            return this.dslMappingDir;
        }
    }

    public static class Elasticsearch {
        private Rest rest;
        private String dateFormat;
        private String timeZone;
        private String ttl;
        private String showTemplate;
        private String sliceScrollThreadCount;
        private String sliceScrollThreadQueue;
        private String sliceScrollBlockedWaitTimeout;
        private String healthCheckInterval;
        private String slowDslThreshold;
        private String useHttps;
        private String slowDslCallback;
        private String includeTypeName;
        private String scrollThreadCount;
        private String scrollThreadQueue;
        private String scrollBlockedWaitTimeout;
        private String discoverHost;

        public void setUseHttps(String useHttps) {
            this.useHttps = useHttps;
        }

        public String getUseHttps() {
            return this.useHttps;
        }

        public String getSlowDslCallback() {
            return this.slowDslCallback;
        }

        public void setSlowDslCallback(String slowDslCallback) {
            this.slowDslCallback = slowDslCallback;
        }

        public String getIncludeTypeName() {
            return this.includeTypeName;
        }

        public void setIncludeTypeName(String includeTypeName) {
            this.includeTypeName = includeTypeName;
        }

        public Rest getRest() {
            return this.rest;
        }

        public void setRest(Rest rest) {
            this.rest = rest;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public String getTtl() {
            return this.ttl;
        }

        public void setTtl(String ttl) {
            this.ttl = ttl;
        }

        public String getShowTemplate() {
            return this.showTemplate;
        }

        public void setShowTemplate(String showTemplate) {
            this.showTemplate = showTemplate;
        }

        public String getDiscoverHost() {
            return this.discoverHost;
        }

        public void setDiscoverHost(String discoverHost) {
            this.discoverHost = discoverHost;
        }

        public String getSliceScrollThreadQueue() {
            return this.sliceScrollThreadQueue;
        }

        public void setSliceScrollThreadQueue(String sliceScrollThreadQueue) {
            this.sliceScrollThreadQueue = sliceScrollThreadQueue;
        }

        public String getSliceScrollThreadCount() {
            return this.sliceScrollThreadCount;
        }

        public void setSliceScrollThreadCount(String sliceScrollThreadCount) {
            this.sliceScrollThreadCount = sliceScrollThreadCount;
        }

        public String getSliceScrollBlockedWaitTimeout() {
            return this.sliceScrollBlockedWaitTimeout;
        }

        public void setSliceScrollBlockedWaitTimeout(String sliceScrollBlockedWaitTimeout) {
            this.sliceScrollBlockedWaitTimeout = sliceScrollBlockedWaitTimeout;
        }

        public String getScrollBlockedWaitTimeout() {
            return this.scrollBlockedWaitTimeout;
        }

        public void setScrollBlockedWaitTimeout(String scrollBlockedWaitTimeout) {
            this.scrollBlockedWaitTimeout = scrollBlockedWaitTimeout;
        }

        public String getScrollThreadQueue() {
            return this.scrollThreadQueue;
        }

        public void setScrollThreadQueue(String scrollThreadQueue) {
            this.scrollThreadQueue = scrollThreadQueue;
        }

        public String getScrollThreadCount() {
            return this.scrollThreadCount;
        }

        public void setScrollThreadCount(String scrollThreadCount) {
            this.scrollThreadCount = scrollThreadCount;
        }

        public String getHealthCheckInterval() {
            return this.healthCheckInterval;
        }

        public void setHealthCheckInterval(String healthCheckInterval) {
            this.healthCheckInterval = healthCheckInterval;
        }

        public String getSlowDslThreshold() {
            return this.slowDslThreshold;
        }

        public void setSlowDslThreshold(String slowDslThreshold) {
            this.slowDslThreshold = slowDslThreshold;
        }
    }

    public static class Http {
        private String keystore;
        private String keyPassword;
        private String hostnameVerifier;
        private String timeoutConnection;
        private String timeoutSocket;
        private String connectionRequestTimeout;
        private String automaticRetriesDisabled;
        private String backoffAuth;
        private String encodedAuthCharset;
        private String retryTime;
        private String retryInterval;
        private String maxLineLength;
        private String maxHeaderCount;
        private String maxTotal;
        private String defaultMaxPerRoute;
        private String soReuseAddress;
        private String soKeepAlive;
        private String timeToLive;
        private String validateAfterInactivity;
        private String keystoreAlias;
        private String trustAlias;
        private String supportedProtocols;
        private String truststore;
        private String trustPassword;
        private String httpClientBuilderCallback;
        private String staleConnectionCheckEnabled = "false";
        private String evictExpiredConnections = "true";
        private String customHttpRequestRetryHandler;
        private String keepAlive;

        public void setEncodedAuthCharset(String encodedAuthCharset) {
            this.encodedAuthCharset = encodedAuthCharset;
        }

        public String getEncodedAuthCharset() {
            return this.encodedAuthCharset;
        }

        public String getHttpClientBuilderCallback() {
            return this.httpClientBuilderCallback;
        }

        public void setBackoffAuth(String backoffAuth) {
            this.backoffAuth = backoffAuth;
        }

        public String getBackoffAuth() {
            return this.backoffAuth;
        }

        public void setHttpClientBuilderCallback(String httpClientBuilderCallback) {
            this.httpClientBuilderCallback = httpClientBuilderCallback;
        }

        public String getEvictExpiredConnections() {
            return this.evictExpiredConnections;
        }

        public void setEvictExpiredConnections(String evictExpiredConnections) {
            this.evictExpiredConnections = evictExpiredConnections;
        }

        public String getTimeoutConnection() {
            return this.timeoutConnection;
        }

        public void setTimeoutConnection(String timeoutConnection) {
            this.timeoutConnection = timeoutConnection;
        }

        public String getTimeoutSocket() {
            return this.timeoutSocket;
        }

        public void setTimeoutSocket(String timeoutSocket) {
            this.timeoutSocket = timeoutSocket;
        }

        public String getConnectionRequestTimeout() {
            return this.connectionRequestTimeout;
        }

        public void setConnectionRequestTimeout(String connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
        }

        public String getRetryTime() {
            return this.retryTime;
        }

        public void setRetryTime(String retryTime) {
            this.retryTime = retryTime;
        }

        public String getMaxLineLength() {
            return this.maxLineLength;
        }

        public void setMaxLineLength(String maxLineLength) {
            this.maxLineLength = maxLineLength;
        }

        public String getMaxHeaderCount() {
            return this.maxHeaderCount;
        }

        public void setMaxHeaderCount(String maxHeaderCount) {
            this.maxHeaderCount = maxHeaderCount;
        }

        public String getMaxTotal() {
            return this.maxTotal;
        }

        public void setMaxTotal(String maxTotal) {
            this.maxTotal = maxTotal;
        }

        public String getDefaultMaxPerRoute() {
            return this.defaultMaxPerRoute;
        }

        public void setDefaultMaxPerRoute(String defaultMaxPerRoute) {
            this.defaultMaxPerRoute = defaultMaxPerRoute;
        }

        public String getSoReuseAddress() {
            return this.soReuseAddress;
        }

        public void setSoReuseAddress(String soReuseAddress) {
            this.soReuseAddress = soReuseAddress;
        }

        public String getSoKeepAlive() {
            return this.soKeepAlive;
        }

        public void setSoKeepAlive(String soKeepAlive) {
            this.soKeepAlive = soKeepAlive;
        }

        public String getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(String timeToLive) {
            this.timeToLive = timeToLive;
        }

        public String getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(String keepAlive) {
            this.keepAlive = keepAlive;
        }

        public String getKeystore() {
            return this.keystore;
        }

        public void setKeystore(String keystore) {
            this.keystore = keystore;
        }

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public String getHostnameVerifier() {
            return this.hostnameVerifier;
        }

        public void setHostnameVerifier(String hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
        }

        public String getValidateAfterInactivity() {
            return this.validateAfterInactivity;
        }

        public void setValidateAfterInactivity(String validateAfterInactivity) {
            this.validateAfterInactivity = validateAfterInactivity;
        }

        public String getCustomHttpRequestRetryHandler() {
            return this.customHttpRequestRetryHandler;
        }

        public void setCustomHttpRequestRetryHandler(String customHttpRequestRetryHandler) {
            this.customHttpRequestRetryHandler = customHttpRequestRetryHandler;
        }

        public String isStaleConnectionCheckEnabled() {
            return this.staleConnectionCheckEnabled;
        }

        public void setStaleConnectionCheckEnabled(String staleConnectionCheckEnabled) {
            this.staleConnectionCheckEnabled = staleConnectionCheckEnabled;
        }

        public String getRetryInterval() {
            return this.retryInterval;
        }

        public void setRetryInterval(String retryInterval) {
            this.retryInterval = retryInterval;
        }

        public String getKeystoreAlias() {
            return this.keystoreAlias;
        }

        public void setKeystoreAlias(String keystoreAlias) {
            this.keystoreAlias = keystoreAlias;
        }

        public String getTrustAlias() {
            return this.trustAlias;
        }

        public void setTrustAlias(String trustAlias) {
            this.trustAlias = trustAlias;
        }

        public String getSupportedProtocols() {
            return this.supportedProtocols;
        }

        public void setSupportedProtocols(String supportedProtocols) {
            this.supportedProtocols = supportedProtocols;
        }

        public String getTruststore() {
            return this.truststore;
        }

        public void setTruststore(String truststore) {
            this.truststore = truststore;
        }

        public String getTrustPassword() {
            return this.trustPassword;
        }

        public void setTrustPassword(String trustPassword) {
            this.trustPassword = trustPassword;
        }

        public String getAutomaticRetriesDisabled() {
            return this.automaticRetriesDisabled;
        }

        public void setAutomaticRetriesDisabled(String automaticRetriesDisabled) {
            this.automaticRetriesDisabled = automaticRetriesDisabled;
        }
    }

    public static class Db {
        private String name;
        private String user;
        private String password;
        private String driver;
        private String url;
        private String usePool;
        private String validateSQL;
        private String maxSize;
        private String minIdleSize;
        private String initSize;
        private String showSql;
        private String dbtype;
        private String dbAdaptor;
        private String jdbcFetchSize;
        private String datasources;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUsePool() {
            return this.usePool;
        }

        public void setUsePool(String usePool) {
            this.usePool = usePool;
        }

        public String getValidateSQL() {
            return this.validateSQL;
        }

        public void setValidateSQL(String validateSQL) {
            this.validateSQL = validateSQL;
        }

        public String getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(String maxSize) {
            this.maxSize = maxSize;
        }

        public String getInitSize() {
            return this.initSize;
        }

        public void setInitSize(String initSize) {
            this.initSize = initSize;
        }

        public String getShowSql() {
            return this.showSql;
        }

        public void setShowSql(String showSql) {
            this.showSql = showSql;
        }

        public String getDbtype() {
            return this.dbtype;
        }

        public void setDbtype(String dbtype) {
            this.dbtype = dbtype;
        }

        public String getDbAdaptor() {
            return this.dbAdaptor;
        }

        public void setDbAdaptor(String dbAdaptor) {
            this.dbAdaptor = dbAdaptor;
        }

        public String getJdbcFetchSize() {
            return this.jdbcFetchSize;
        }

        public void setJdbcFetchSize(String jdbcFetchSize) {
            this.jdbcFetchSize = jdbcFetchSize;
        }

        public String getMinIdleSize() {
            return this.minIdleSize;
        }

        public void setMinIdleSize(String minIdleSize) {
            this.minIdleSize = minIdleSize;
        }

        public String getDatasources() {
            return this.datasources;
        }

        public void setDatasources(String datasources) {
            this.datasources = datasources;
        }
    }

    public static class Ip {
        private String serviceUrl;
        private String cachesize;
        private String database;
        private String asnDatabase;

        public String getServiceUrl() {
            return this.serviceUrl;
        }

        public void setServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        public String getCachesize() {
            return this.cachesize;
        }

        public void setCachesize(String cachesize) {
            this.cachesize = cachesize;
        }

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public String getAsnDatabase() {
            return this.asnDatabase;
        }

        public void setAsnDatabase(String asnDatabase) {
            this.asnDatabase = asnDatabase;
        }
    }
}

