/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.word.parse.excel;

import cn.afterturn.easypoi.util.PoiElUtil;
import cn.afterturn.easypoi.util.PoiWordStyleUtil;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelMapParse {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelMapParse.class);

    private static String[] parseCurrentRowGetParams(XWPFTableRow currentRow) {
        List cells = currentRow.getTableCells();
        String[] params = new String[cells.size()];
        for (int i = 0; i < cells.size(); ++i) {
            String text = ((XWPFTableCell)cells.get(i)).getText();
            params[i] = text == null ? "" : text.trim().replace("{{", "").replace("}}", "");
        }
        return params;
    }

    public static void parseNextRowAndAddRow(XWPFTable table, int index, List<Object> list) throws Exception {
        XWPFTableRow currentRow = table.getRow(index);
        String[] params = ExcelMapParse.parseCurrentRowGetParams(currentRow);
        String listname = params[0];
        boolean isCreate = !listname.contains("!fe:");
        listname = listname.replace("!fe:", "").replace("$fe:", "").replace("fe:", "").replace("{{", "");
        String[] keys = listname.replaceAll("\\s{1,}", " ").trim().split(" ");
        params[0] = keys[1];
        ArrayList tempCellList = new ArrayList();
        tempCellList.addAll(table.getRow(index).getTableCells());
        int templateInde = index;
        int cellIndex = 0;
        HashMap tempMap = Maps.newHashMap();
        LOGGER.debug("start for each data list :{}", (Object)list.size());
        for (Object obj : list) {
            String val;
            currentRow = isCreate ? table.insertNewTableRow(index++) : table.getRow(index++);
            tempMap.put("t", obj);
            for (cellIndex = 0; cellIndex < currentRow.getTableCells().size(); ++cellIndex) {
                val = PoiElUtil.eval(params[cellIndex], tempMap).toString();
                ((XWPFTableCell)currentRow.getTableCells().get(cellIndex)).setText("");
                PoiWordStyleUtil.copyCellAndSetValue((XWPFTableCell)tempCellList.get(cellIndex), (XWPFTableCell)currentRow.getTableCells().get(cellIndex), val);
            }
            while (cellIndex < params.length) {
                val = PoiElUtil.eval(params[cellIndex], tempMap).toString();
                PoiWordStyleUtil.copyCellAndSetValue((XWPFTableCell)tempCellList.get(cellIndex), currentRow.createCell(), val);
                ++cellIndex;
            }
        }
        table.removeRow(index);
    }
}

