/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Transportation details for this shipment.")
public class TransportationDetailsForShipmentConfirmation {
    @SerializedName(value="carrierScac")
    private String carrierScac = null;
    @SerializedName(value="carrierShipmentReferenceNumber")
    private String carrierShipmentReferenceNumber = null;
    @SerializedName(value="transportationMode")
    private TransportationModeEnum transportationMode = null;
    @SerializedName(value="billOfLadingNumber")
    private String billOfLadingNumber = null;

    public TransportationDetailsForShipmentConfirmation carrierScac(String carrierScac) {
        this.carrierScac = carrierScac;
        return this;
    }

    @Schema(description="Code that identifies the carrier for the shipment. The Standard Carrier Alpha Code (SCAC) is a unique two to four letter code used to identify a carrier. Carrier SCAC codes are assigned and maintained by the NMFTA (National Motor Freight Association). This field is mandatory for US, CA, MX shipment confirmations.")
    public String getCarrierScac() {
        return this.carrierScac;
    }

    public void setCarrierScac(String carrierScac) {
        this.carrierScac = carrierScac;
    }

    public TransportationDetailsForShipmentConfirmation carrierShipmentReferenceNumber(String carrierShipmentReferenceNumber) {
        this.carrierShipmentReferenceNumber = carrierShipmentReferenceNumber;
        return this;
    }

    @Schema(description="The field also known as PRO number is a unique number assigned by the carrier. It is used to identify and track the shipment that goes out for delivery. This field is mandatory for UA, CA, MX shipment confirmations.")
    public String getCarrierShipmentReferenceNumber() {
        return this.carrierShipmentReferenceNumber;
    }

    public void setCarrierShipmentReferenceNumber(String carrierShipmentReferenceNumber) {
        this.carrierShipmentReferenceNumber = carrierShipmentReferenceNumber;
    }

    public TransportationDetailsForShipmentConfirmation transportationMode(TransportationModeEnum transportationMode) {
        this.transportationMode = transportationMode;
        return this;
    }

    @Schema(description="The mode of transportation for this shipment.")
    public TransportationModeEnum getTransportationMode() {
        return this.transportationMode;
    }

    public void setTransportationMode(TransportationModeEnum transportationMode) {
        this.transportationMode = transportationMode;
    }

    public TransportationDetailsForShipmentConfirmation billOfLadingNumber(String billOfLadingNumber) {
        this.billOfLadingNumber = billOfLadingNumber;
        return this;
    }

    @Schema(description="The Bill of Lading (BOL) number is a unique number assigned to each shipment of goods by the vendor or shipper during the creation of the Bill of Lading. This number must be unique for every shipment and cannot be a date/time or single character. The BOL numer is mandatory in Shipment Confirmation message for FTL and LTL shipments, and must match the paper BOL provided with the shipment. Instead of BOL, an alternative reference number (like Delivery Note Number) for the shipment can also be sent in this field.")
    public String getBillOfLadingNumber() {
        return this.billOfLadingNumber;
    }

    public void setBillOfLadingNumber(String billOfLadingNumber) {
        this.billOfLadingNumber = billOfLadingNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportationDetailsForShipmentConfirmation transportationDetailsForShipmentConfirmation = (TransportationDetailsForShipmentConfirmation)o;
        return Objects.equals(this.carrierScac, transportationDetailsForShipmentConfirmation.carrierScac) && Objects.equals(this.carrierShipmentReferenceNumber, transportationDetailsForShipmentConfirmation.carrierShipmentReferenceNumber) && Objects.equals((Object)this.transportationMode, (Object)transportationDetailsForShipmentConfirmation.transportationMode) && Objects.equals(this.billOfLadingNumber, transportationDetailsForShipmentConfirmation.billOfLadingNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.carrierScac, this.carrierShipmentReferenceNumber, this.transportationMode, this.billOfLadingNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransportationDetailsForShipmentConfirmation {\n");
        sb.append("    carrierScac: ").append(this.toIndentedString(this.carrierScac)).append("\n");
        sb.append("    carrierShipmentReferenceNumber: ").append(this.toIndentedString(this.carrierShipmentReferenceNumber)).append("\n");
        sb.append("    transportationMode: ").append(this.toIndentedString((Object)this.transportationMode)).append("\n");
        sb.append("    billOfLadingNumber: ").append(this.toIndentedString(this.billOfLadingNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransportationModeEnum {
        ROAD("Road"),
        AIR("Air"),
        OCEAN("Ocean");

        private String value;

        private TransportationModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransportationModeEnum fromValue(String input) {
            for (TransportationModeEnum b : TransportationModeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TransportationModeEnum> {
            public void write(JsonWriter jsonWriter, TransportationModeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TransportationModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransportationModeEnum.fromValue(value);
            }
        }
    }
}

