/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.shipments.v1.CarrierDetails;

@Schema(description="Transportation details for this shipment.")
public class TransportationDetails {
    @SerializedName(value="shipMode")
    private ShipModeEnum shipMode = null;
    @SerializedName(value="transportationMode")
    private TransportationModeEnum transportationMode = null;
    @SerializedName(value="shippedDate")
    private OffsetDateTime shippedDate = null;
    @SerializedName(value="estimatedDeliveryDate")
    private OffsetDateTime estimatedDeliveryDate = null;
    @SerializedName(value="shipmentDeliveryDate")
    private OffsetDateTime shipmentDeliveryDate = null;
    @SerializedName(value="carrierDetails")
    private CarrierDetails carrierDetails = null;
    @SerializedName(value="billOfLadingNumber")
    private String billOfLadingNumber = null;

    public TransportationDetails shipMode(ShipModeEnum shipMode) {
        this.shipMode = shipMode;
        return this;
    }

    @Schema(description="The type of shipment.")
    public ShipModeEnum getShipMode() {
        return this.shipMode;
    }

    public void setShipMode(ShipModeEnum shipMode) {
        this.shipMode = shipMode;
    }

    public TransportationDetails transportationMode(TransportationModeEnum transportationMode) {
        this.transportationMode = transportationMode;
        return this;
    }

    @Schema(description="The mode of transportation for this shipment.")
    public TransportationModeEnum getTransportationMode() {
        return this.transportationMode;
    }

    public void setTransportationMode(TransportationModeEnum transportationMode) {
        this.transportationMode = transportationMode;
    }

    public TransportationDetails shippedDate(OffsetDateTime shippedDate) {
        this.shippedDate = shippedDate;
        return this;
    }

    @Schema(description="Date when shipment is performed by the Vendor to Buyer")
    public OffsetDateTime getShippedDate() {
        return this.shippedDate;
    }

    public void setShippedDate(OffsetDateTime shippedDate) {
        this.shippedDate = shippedDate;
    }

    public TransportationDetails estimatedDeliveryDate(OffsetDateTime estimatedDeliveryDate) {
        this.estimatedDeliveryDate = estimatedDeliveryDate;
        return this;
    }

    @Schema(description="Estimated Date on which shipment will be delivered from Vendor to Buyer")
    public OffsetDateTime getEstimatedDeliveryDate() {
        return this.estimatedDeliveryDate;
    }

    public void setEstimatedDeliveryDate(OffsetDateTime estimatedDeliveryDate) {
        this.estimatedDeliveryDate = estimatedDeliveryDate;
    }

    public TransportationDetails shipmentDeliveryDate(OffsetDateTime shipmentDeliveryDate) {
        this.shipmentDeliveryDate = shipmentDeliveryDate;
        return this;
    }

    @Schema(description="Date on which shipment will be delivered from Vendor to Buyer")
    public OffsetDateTime getShipmentDeliveryDate() {
        return this.shipmentDeliveryDate;
    }

    public void setShipmentDeliveryDate(OffsetDateTime shipmentDeliveryDate) {
        this.shipmentDeliveryDate = shipmentDeliveryDate;
    }

    public TransportationDetails carrierDetails(CarrierDetails carrierDetails) {
        this.carrierDetails = carrierDetails;
        return this;
    }

    @Schema(description="")
    public CarrierDetails getCarrierDetails() {
        return this.carrierDetails;
    }

    public void setCarrierDetails(CarrierDetails carrierDetails) {
        this.carrierDetails = carrierDetails;
    }

    public TransportationDetails billOfLadingNumber(String billOfLadingNumber) {
        this.billOfLadingNumber = billOfLadingNumber;
        return this;
    }

    @Schema(description="The Bill of Lading (BOL) number is a unique number assigned to each shipment of goods by the vendor or shipper during the creation of the Bill of Lading. This number must be unique for every shipment and cannot be a date/time or single character. The BOL numer is mandatory in Shipment Confirmation message for FTL and LTL shipments, and must match the paper BOL provided with the shipment. Instead of BOL, an alternative reference number (like Delivery Note Number) for the shipment can also be sent in this field.")
    public String getBillOfLadingNumber() {
        return this.billOfLadingNumber;
    }

    public void setBillOfLadingNumber(String billOfLadingNumber) {
        this.billOfLadingNumber = billOfLadingNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportationDetails transportationDetails = (TransportationDetails)o;
        return Objects.equals((Object)this.shipMode, (Object)transportationDetails.shipMode) && Objects.equals((Object)this.transportationMode, (Object)transportationDetails.transportationMode) && Objects.equals(this.shippedDate, transportationDetails.shippedDate) && Objects.equals(this.estimatedDeliveryDate, transportationDetails.estimatedDeliveryDate) && Objects.equals(this.shipmentDeliveryDate, transportationDetails.shipmentDeliveryDate) && Objects.equals(this.carrierDetails, transportationDetails.carrierDetails) && Objects.equals(this.billOfLadingNumber, transportationDetails.billOfLadingNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shipMode, this.transportationMode, this.shippedDate, this.estimatedDeliveryDate, this.shipmentDeliveryDate, this.carrierDetails, this.billOfLadingNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransportationDetails {\n");
        sb.append("    shipMode: ").append(this.toIndentedString((Object)this.shipMode)).append("\n");
        sb.append("    transportationMode: ").append(this.toIndentedString((Object)this.transportationMode)).append("\n");
        sb.append("    shippedDate: ").append(this.toIndentedString(this.shippedDate)).append("\n");
        sb.append("    estimatedDeliveryDate: ").append(this.toIndentedString(this.estimatedDeliveryDate)).append("\n");
        sb.append("    shipmentDeliveryDate: ").append(this.toIndentedString(this.shipmentDeliveryDate)).append("\n");
        sb.append("    carrierDetails: ").append(this.toIndentedString(this.carrierDetails)).append("\n");
        sb.append("    billOfLadingNumber: ").append(this.toIndentedString(this.billOfLadingNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransportationModeEnum {
        ROAD("Road"),
        AIR("Air"),
        OCEAN("Ocean");

        private String value;

        private TransportationModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransportationModeEnum fromValue(String input) {
            for (TransportationModeEnum b : TransportationModeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TransportationModeEnum> {
            public void write(JsonWriter jsonWriter, TransportationModeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TransportationModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransportationModeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShipModeEnum {
        TRUCKLOAD("TruckLoad"),
        LESSTHANTRUCKLOAD("LessThanTruckLoad"),
        SMALLPARCEL("SmallParcel");

        private String value;

        private ShipModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShipModeEnum fromValue(String input) {
            for (ShipModeEnum b : ShipModeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShipModeEnum> {
            public void write(JsonWriter jsonWriter, ShipModeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ShipModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShipModeEnum.fromValue(value);
            }
        }
    }
}

