/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.Volume;
import software.amazon.spapi.models.vendor.shipments.v1.Weight;

@Schema(description="Shipment measurement details.")
public class TransportShipmentMeasurements {
    @SerializedName(value="totalCartonCount")
    private Integer totalCartonCount = null;
    @SerializedName(value="totalPalletStackable")
    private Integer totalPalletStackable = null;
    @SerializedName(value="totalPalletNonStackable")
    private Integer totalPalletNonStackable = null;
    @SerializedName(value="shipmentWeight")
    private Weight shipmentWeight = null;
    @SerializedName(value="shipmentVolume")
    private Volume shipmentVolume = null;

    public TransportShipmentMeasurements totalCartonCount(Integer totalCartonCount) {
        this.totalCartonCount = totalCartonCount;
        return this;
    }

    @Schema(description="Total number of cartons present in the shipment. Provide the cartonCount only for non-palletized shipments.")
    public Integer getTotalCartonCount() {
        return this.totalCartonCount;
    }

    public void setTotalCartonCount(Integer totalCartonCount) {
        this.totalCartonCount = totalCartonCount;
    }

    public TransportShipmentMeasurements totalPalletStackable(Integer totalPalletStackable) {
        this.totalPalletStackable = totalPalletStackable;
        return this;
    }

    @Schema(description="Total number of Stackable Pallets present in the shipment.")
    public Integer getTotalPalletStackable() {
        return this.totalPalletStackable;
    }

    public void setTotalPalletStackable(Integer totalPalletStackable) {
        this.totalPalletStackable = totalPalletStackable;
    }

    public TransportShipmentMeasurements totalPalletNonStackable(Integer totalPalletNonStackable) {
        this.totalPalletNonStackable = totalPalletNonStackable;
        return this;
    }

    @Schema(description="Total number of Non Stackable Pallets present in the shipment.")
    public Integer getTotalPalletNonStackable() {
        return this.totalPalletNonStackable;
    }

    public void setTotalPalletNonStackable(Integer totalPalletNonStackable) {
        this.totalPalletNonStackable = totalPalletNonStackable;
    }

    public TransportShipmentMeasurements shipmentWeight(Weight shipmentWeight) {
        this.shipmentWeight = shipmentWeight;
        return this;
    }

    @Schema(description="")
    public Weight getShipmentWeight() {
        return this.shipmentWeight;
    }

    public void setShipmentWeight(Weight shipmentWeight) {
        this.shipmentWeight = shipmentWeight;
    }

    public TransportShipmentMeasurements shipmentVolume(Volume shipmentVolume) {
        this.shipmentVolume = shipmentVolume;
        return this;
    }

    @Schema(description="")
    public Volume getShipmentVolume() {
        return this.shipmentVolume;
    }

    public void setShipmentVolume(Volume shipmentVolume) {
        this.shipmentVolume = shipmentVolume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportShipmentMeasurements transportShipmentMeasurements = (TransportShipmentMeasurements)o;
        return Objects.equals(this.totalCartonCount, transportShipmentMeasurements.totalCartonCount) && Objects.equals(this.totalPalletStackable, transportShipmentMeasurements.totalPalletStackable) && Objects.equals(this.totalPalletNonStackable, transportShipmentMeasurements.totalPalletNonStackable) && Objects.equals(this.shipmentWeight, transportShipmentMeasurements.shipmentWeight) && Objects.equals(this.shipmentVolume, transportShipmentMeasurements.shipmentVolume);
    }

    public int hashCode() {
        return Objects.hash(this.totalCartonCount, this.totalPalletStackable, this.totalPalletNonStackable, this.shipmentWeight, this.shipmentVolume);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransportShipmentMeasurements {\n");
        sb.append("    totalCartonCount: ").append(this.toIndentedString(this.totalCartonCount)).append("\n");
        sb.append("    totalPalletStackable: ").append(this.toIndentedString(this.totalPalletStackable)).append("\n");
        sb.append("    totalPalletNonStackable: ").append(this.toIndentedString(this.totalPalletNonStackable)).append("\n");
        sb.append("    shipmentWeight: ").append(this.toIndentedString(this.shipmentWeight)).append("\n");
        sb.append("    shipmentVolume: ").append(this.toIndentedString(this.shipmentVolume)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

