/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.shipments.v1.Location;

@Schema(description="Contractual or operational port or point relevant to the movement of the cargo.")
public class Stop {
    @SerializedName(value="functionCode")
    private FunctionCodeEnum functionCode = null;
    @SerializedName(value="locationIdentification")
    private Location locationIdentification = null;
    @SerializedName(value="arrivalTime")
    private OffsetDateTime arrivalTime = null;
    @SerializedName(value="departureTime")
    private OffsetDateTime departureTime = null;

    public Stop functionCode(FunctionCodeEnum functionCode) {
        this.functionCode = functionCode;
        return this;
    }

    @Schema(required=true, description="Provide the function code.")
    public FunctionCodeEnum getFunctionCode() {
        return this.functionCode;
    }

    public void setFunctionCode(FunctionCodeEnum functionCode) {
        this.functionCode = functionCode;
    }

    public Stop locationIdentification(Location locationIdentification) {
        this.locationIdentification = locationIdentification;
        return this;
    }

    @Schema(description="")
    public Location getLocationIdentification() {
        return this.locationIdentification;
    }

    public void setLocationIdentification(Location locationIdentification) {
        this.locationIdentification = locationIdentification;
    }

    public Stop arrivalTime(OffsetDateTime arrivalTime) {
        this.arrivalTime = arrivalTime;
        return this;
    }

    @Schema(description="Date and time of the arrival of the cargo.")
    public OffsetDateTime getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(OffsetDateTime arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public Stop departureTime(OffsetDateTime departureTime) {
        this.departureTime = departureTime;
        return this;
    }

    @Schema(description="Date and time of the departure of the cargo.")
    public OffsetDateTime getDepartureTime() {
        return this.departureTime;
    }

    public void setDepartureTime(OffsetDateTime departureTime) {
        this.departureTime = departureTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stop stop = (Stop)o;
        return Objects.equals((Object)this.functionCode, (Object)stop.functionCode) && Objects.equals(this.locationIdentification, stop.locationIdentification) && Objects.equals(this.arrivalTime, stop.arrivalTime) && Objects.equals(this.departureTime, stop.departureTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.functionCode, this.locationIdentification, this.arrivalTime, this.departureTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Stop {\n");
        sb.append("    functionCode: ").append(this.toIndentedString((Object)this.functionCode)).append("\n");
        sb.append("    locationIdentification: ").append(this.toIndentedString(this.locationIdentification)).append("\n");
        sb.append("    arrivalTime: ").append(this.toIndentedString(this.arrivalTime)).append("\n");
        sb.append("    departureTime: ").append(this.toIndentedString(this.departureTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FunctionCodeEnum {
        PORTOFDISCHARGE("PortOfDischarge"),
        FREIGHTPAYABLEAT("FreightPayableAt"),
        PORTOFLOADING("PortOfLoading");

        private String value;

        private FunctionCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FunctionCodeEnum fromValue(String input) {
            for (FunctionCodeEnum b : FunctionCodeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FunctionCodeEnum> {
            public void write(JsonWriter jsonWriter, FunctionCodeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public FunctionCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FunctionCodeEnum.fromValue(value);
            }
        }
    }
}

