/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.shipments.v1.PurchaseOrderItems;

@Schema(description="Transport Request pickup date")
public class PurchaseOrders {
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="purchaseOrderDate")
    private OffsetDateTime purchaseOrderDate = null;
    @SerializedName(value="shipWindow")
    private String shipWindow = null;
    @SerializedName(value="items")
    private List<PurchaseOrderItems> items = null;

    public PurchaseOrders purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(description="Purchase order numbers involved in this shipment, list all the PO that are involved as part of this shipment.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public PurchaseOrders purchaseOrderDate(OffsetDateTime purchaseOrderDate) {
        this.purchaseOrderDate = purchaseOrderDate;
        return this;
    }

    @Schema(description="Purchase order numbers involved in this shipment, list all the PO that are involved as part of this shipment.")
    public OffsetDateTime getPurchaseOrderDate() {
        return this.purchaseOrderDate;
    }

    public void setPurchaseOrderDate(OffsetDateTime purchaseOrderDate) {
        this.purchaseOrderDate = purchaseOrderDate;
    }

    public PurchaseOrders shipWindow(String shipWindow) {
        this.shipWindow = shipWindow;
        return this;
    }

    @Schema(description="Date range in which shipment is expected for these purchase orders.")
    public String getShipWindow() {
        return this.shipWindow;
    }

    public void setShipWindow(String shipWindow) {
        this.shipWindow = shipWindow;
    }

    public PurchaseOrders items(List<PurchaseOrderItems> items) {
        this.items = items;
        return this;
    }

    public PurchaseOrders addItemsItem(PurchaseOrderItems itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<PurchaseOrderItems>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Schema(description="A list of the items that are associated to the PO in this transport and their associated details.")
    public List<PurchaseOrderItems> getItems() {
        return this.items;
    }

    public void setItems(List<PurchaseOrderItems> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurchaseOrders purchaseOrders = (PurchaseOrders)o;
        return Objects.equals(this.purchaseOrderNumber, purchaseOrders.purchaseOrderNumber) && Objects.equals(this.purchaseOrderDate, purchaseOrders.purchaseOrderDate) && Objects.equals(this.shipWindow, purchaseOrders.shipWindow) && Objects.equals(this.items, purchaseOrders.items);
    }

    public int hashCode() {
        return Objects.hash(this.purchaseOrderNumber, this.purchaseOrderDate, this.shipWindow, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PurchaseOrders {\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    purchaseOrderDate: ").append(this.toIndentedString(this.purchaseOrderDate)).append("\n");
        sb.append("    shipWindow: ").append(this.toIndentedString(this.shipWindow)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

