/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.CartonReferenceDetails;
import software.amazon.spapi.models.vendor.shipments.v1.ContainerIdentification;
import software.amazon.spapi.models.vendor.shipments.v1.ContainerItem;
import software.amazon.spapi.models.vendor.shipments.v1.Dimensions;
import software.amazon.spapi.models.vendor.shipments.v1.Weight;

@Schema(description="Details of the Pallet/Tare being shipped.")
public class Pallet {
    @SerializedName(value="palletIdentifiers")
    private List<ContainerIdentification> palletIdentifiers = new ArrayList<ContainerIdentification>();
    @SerializedName(value="tier")
    private Integer tier = null;
    @SerializedName(value="block")
    private Integer block = null;
    @SerializedName(value="dimensions")
    private Dimensions dimensions = null;
    @SerializedName(value="weight")
    private Weight weight = null;
    @SerializedName(value="cartonReferenceDetails")
    private CartonReferenceDetails cartonReferenceDetails = null;
    @SerializedName(value="items")
    private List<ContainerItem> items = null;

    public Pallet palletIdentifiers(List<ContainerIdentification> palletIdentifiers) {
        this.palletIdentifiers = palletIdentifiers;
        return this;
    }

    public Pallet addPalletIdentifiersItem(ContainerIdentification palletIdentifiersItem) {
        this.palletIdentifiers.add(palletIdentifiersItem);
        return this;
    }

    @Schema(required=true, description="A list of pallet identifiers.")
    public List<ContainerIdentification> getPalletIdentifiers() {
        return this.palletIdentifiers;
    }

    public void setPalletIdentifiers(List<ContainerIdentification> palletIdentifiers) {
        this.palletIdentifiers = palletIdentifiers;
    }

    public Pallet tier(Integer tier) {
        this.tier = tier;
        return this;
    }

    @Schema(description="Number of layers per pallet. Only applicable to container type Pallet.")
    public Integer getTier() {
        return this.tier;
    }

    public void setTier(Integer tier) {
        this.tier = tier;
    }

    public Pallet block(Integer block) {
        this.block = block;
        return this;
    }

    @Schema(description="Number of cartons per layer on the pallet. Only applicable to container type Pallet.")
    public Integer getBlock() {
        return this.block;
    }

    public void setBlock(Integer block) {
        this.block = block;
    }

    public Pallet dimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @Schema(description="")
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public Pallet weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @Schema(description="")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public Pallet cartonReferenceDetails(CartonReferenceDetails cartonReferenceDetails) {
        this.cartonReferenceDetails = cartonReferenceDetails;
        return this;
    }

    @Schema(description="")
    public CartonReferenceDetails getCartonReferenceDetails() {
        return this.cartonReferenceDetails;
    }

    public void setCartonReferenceDetails(CartonReferenceDetails cartonReferenceDetails) {
        this.cartonReferenceDetails = cartonReferenceDetails;
    }

    public Pallet items(List<ContainerItem> items) {
        this.items = items;
        return this;
    }

    public Pallet addItemsItem(ContainerItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<ContainerItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Schema(description="A list of container item details.")
    public List<ContainerItem> getItems() {
        return this.items;
    }

    public void setItems(List<ContainerItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pallet pallet = (Pallet)o;
        return Objects.equals(this.palletIdentifiers, pallet.palletIdentifiers) && Objects.equals(this.tier, pallet.tier) && Objects.equals(this.block, pallet.block) && Objects.equals(this.dimensions, pallet.dimensions) && Objects.equals(this.weight, pallet.weight) && Objects.equals(this.cartonReferenceDetails, pallet.cartonReferenceDetails) && Objects.equals(this.items, pallet.items);
    }

    public int hashCode() {
        return Objects.hash(this.palletIdentifiers, this.tier, this.block, this.dimensions, this.weight, this.cartonReferenceDetails, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pallet {\n");
        sb.append("    palletIdentifiers: ").append(this.toIndentedString(this.palletIdentifiers)).append("\n");
        sb.append("    tier: ").append(this.toIndentedString(this.tier)).append("\n");
        sb.append("    block: ").append(this.toIndentedString(this.block)).append("\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    cartonReferenceDetails: ").append(this.toIndentedString(this.cartonReferenceDetails)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

