/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Label details as part of the transport label response")
public class LabelData {
    @SerializedName(value="labelSequenceNumber")
    private Integer labelSequenceNumber = null;
    @SerializedName(value="labelFormat")
    private LabelFormatEnum labelFormat = null;
    @SerializedName(value="carrierCode")
    private String carrierCode = null;
    @SerializedName(value="trackingId")
    private String trackingId = null;
    @SerializedName(value="label")
    private String label = null;

    public LabelData labelSequenceNumber(Integer labelSequenceNumber) {
        this.labelSequenceNumber = labelSequenceNumber;
        return this;
    }

    @Schema(description="A sequential number assigned to each label within a shipment.")
    public Integer getLabelSequenceNumber() {
        return this.labelSequenceNumber;
    }

    public void setLabelSequenceNumber(Integer labelSequenceNumber) {
        this.labelSequenceNumber = labelSequenceNumber;
    }

    public LabelData labelFormat(LabelFormatEnum labelFormat) {
        this.labelFormat = labelFormat;
        return this;
    }

    @Schema(description="The format of the label.")
    public LabelFormatEnum getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(LabelFormatEnum labelFormat) {
        this.labelFormat = labelFormat;
    }

    public LabelData carrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
        return this;
    }

    @Schema(description="Unique identification of the carrier.")
    public String getCarrierCode() {
        return this.carrierCode;
    }

    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    public LabelData trackingId(String trackingId) {
        this.trackingId = trackingId;
        return this;
    }

    @Schema(description="Tracking Id for the transportation.")
    public String getTrackingId() {
        return this.trackingId;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    public LabelData label(String label) {
        this.label = label;
        return this;
    }

    @Schema(description="The base-64 encoded string that represents the shipment label.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelData labelData = (LabelData)o;
        return Objects.equals(this.labelSequenceNumber, labelData.labelSequenceNumber) && Objects.equals((Object)this.labelFormat, (Object)labelData.labelFormat) && Objects.equals(this.carrierCode, labelData.carrierCode) && Objects.equals(this.trackingId, labelData.trackingId) && Objects.equals(this.label, labelData.label);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.labelSequenceNumber, this.labelFormat, this.carrierCode, this.trackingId, this.label});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LabelData {\n");
        sb.append("    labelSequenceNumber: ").append(this.toIndentedString(this.labelSequenceNumber)).append("\n");
        sb.append("    labelFormat: ").append(this.toIndentedString((Object)this.labelFormat)).append("\n");
        sb.append("    carrierCode: ").append(this.toIndentedString(this.carrierCode)).append("\n");
        sb.append("    trackingId: ").append(this.toIndentedString(this.trackingId)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LabelFormatEnum {
        PDF("PDF");

        private String value;

        private LabelFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LabelFormatEnum fromValue(String input) {
            for (LabelFormatEnum b : LabelFormatEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LabelFormatEnum> {
            public void write(JsonWriter jsonWriter, LabelFormatEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public LabelFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LabelFormatEnum.fromValue(value);
            }
        }
    }
}

