/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.ItemDetails;
import software.amazon.spapi.models.vendor.shipments.v1.ItemQuantity;

@Schema(description="Details of the item being shipped.")
public class Item {
    @SerializedName(value="itemSequenceNumber")
    private String itemSequenceNumber = null;
    @SerializedName(value="amazonProductIdentifier")
    private String amazonProductIdentifier = null;
    @SerializedName(value="vendorProductIdentifier")
    private String vendorProductIdentifier = null;
    @SerializedName(value="shippedQuantity")
    private ItemQuantity shippedQuantity = null;
    @SerializedName(value="itemDetails")
    private ItemDetails itemDetails = null;

    public Item itemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
        return this;
    }

    @Schema(required=true, description="Item sequence number for the item. The first item will be 001, the second 002, and so on. This number is used as a reference to refer to this item from the carton or pallet level.")
    public String getItemSequenceNumber() {
        return this.itemSequenceNumber;
    }

    public void setItemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
    }

    public Item amazonProductIdentifier(String amazonProductIdentifier) {
        this.amazonProductIdentifier = amazonProductIdentifier;
        return this;
    }

    @Schema(description="Buyer Standard Identification Number (ASIN) of an item.")
    public String getAmazonProductIdentifier() {
        return this.amazonProductIdentifier;
    }

    public void setAmazonProductIdentifier(String amazonProductIdentifier) {
        this.amazonProductIdentifier = amazonProductIdentifier;
    }

    public Item vendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
        return this;
    }

    @Schema(description="The vendor selected product identification of the item. Should be the same as was sent in the purchase order.")
    public String getVendorProductIdentifier() {
        return this.vendorProductIdentifier;
    }

    public void setVendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
    }

    public Item shippedQuantity(ItemQuantity shippedQuantity) {
        this.shippedQuantity = shippedQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public ItemQuantity getShippedQuantity() {
        return this.shippedQuantity;
    }

    public void setShippedQuantity(ItemQuantity shippedQuantity) {
        this.shippedQuantity = shippedQuantity;
    }

    public Item itemDetails(ItemDetails itemDetails) {
        this.itemDetails = itemDetails;
        return this;
    }

    @Schema(description="")
    public ItemDetails getItemDetails() {
        return this.itemDetails;
    }

    public void setItemDetails(ItemDetails itemDetails) {
        this.itemDetails = itemDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.itemSequenceNumber, item.itemSequenceNumber) && Objects.equals(this.amazonProductIdentifier, item.amazonProductIdentifier) && Objects.equals(this.vendorProductIdentifier, item.vendorProductIdentifier) && Objects.equals(this.shippedQuantity, item.shippedQuantity) && Objects.equals(this.itemDetails, item.itemDetails);
    }

    public int hashCode() {
        return Objects.hash(this.itemSequenceNumber, this.amazonProductIdentifier, this.vendorProductIdentifier, this.shippedQuantity, this.itemDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Item {\n");
        sb.append("    itemSequenceNumber: ").append(this.toIndentedString(this.itemSequenceNumber)).append("\n");
        sb.append("    amazonProductIdentifier: ").append(this.toIndentedString(this.amazonProductIdentifier)).append("\n");
        sb.append("    vendorProductIdentifier: ").append(this.toIndentedString(this.vendorProductIdentifier)).append("\n");
        sb.append("    shippedQuantity: ").append(this.toIndentedString(this.shippedQuantity)).append("\n");
        sb.append("    itemDetails: ").append(this.toIndentedString(this.itemDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

