/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.shipments.v1.Duration;

@Schema(description="Expiry refers to the collection of dates required  for certain items. These could be either expiryDate or mfgDate and expiryAfterDuration. These are mandatory for perishable items.")
public class Expiry {
    @SerializedName(value="manufacturerDate")
    private OffsetDateTime manufacturerDate = null;
    @SerializedName(value="expiryDate")
    private OffsetDateTime expiryDate = null;
    @SerializedName(value="expiryAfterDuration")
    private Duration expiryAfterDuration = null;

    public Expiry manufacturerDate(OffsetDateTime manufacturerDate) {
        this.manufacturerDate = manufacturerDate;
        return this;
    }

    @Schema(description="Production, packaging or assembly date determined by the manufacturer. Its meaning is determined based on the trade item context.")
    public OffsetDateTime getManufacturerDate() {
        return this.manufacturerDate;
    }

    public void setManufacturerDate(OffsetDateTime manufacturerDate) {
        this.manufacturerDate = manufacturerDate;
    }

    public Expiry expiryDate(OffsetDateTime expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @Schema(description="The date that determines the limit of consumption or use of a product. Its meaning is determined based on the trade item context.")
    public OffsetDateTime getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(OffsetDateTime expiryDate) {
        this.expiryDate = expiryDate;
    }

    public Expiry expiryAfterDuration(Duration expiryAfterDuration) {
        this.expiryAfterDuration = expiryAfterDuration;
        return this;
    }

    @Schema(description="")
    public Duration getExpiryAfterDuration() {
        return this.expiryAfterDuration;
    }

    public void setExpiryAfterDuration(Duration expiryAfterDuration) {
        this.expiryAfterDuration = expiryAfterDuration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expiry expiry = (Expiry)o;
        return Objects.equals(this.manufacturerDate, expiry.manufacturerDate) && Objects.equals(this.expiryDate, expiry.expiryDate) && Objects.equals(this.expiryAfterDuration, expiry.expiryAfterDuration);
    }

    public int hashCode() {
        return Objects.hash(this.manufacturerDate, this.expiryDate, this.expiryAfterDuration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Expiry {\n");
        sb.append("    manufacturerDate: ").append(this.toIndentedString(this.manufacturerDate)).append("\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    expiryAfterDuration: ").append(this.toIndentedString(this.expiryAfterDuration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

