/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Physical dimensional measurements of a container.")
public class Dimensions {
    @SerializedName(value="length")
    private String length = null;
    @SerializedName(value="width")
    private String width = null;
    @SerializedName(value="height")
    private String height = null;
    @SerializedName(value="unitOfMeasure")
    private UnitOfMeasureEnum unitOfMeasure = null;

    public Dimensions length(String length) {
        this.length = length;
        return this;
    }

    @Schema(required=true, description="")
    public String getLength() {
        return this.length;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public Dimensions width(String width) {
        this.width = width;
        return this;
    }

    @Schema(required=true, description="")
    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public Dimensions height(String height) {
        this.height = height;
        return this;
    }

    @Schema(required=true, description="")
    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public Dimensions unitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(required=true, description="The unit of measure for dimensions.")
    public UnitOfMeasureEnum getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dimensions dimensions = (Dimensions)o;
        return Objects.equals(this.length, dimensions.length) && Objects.equals(this.width, dimensions.width) && Objects.equals(this.height, dimensions.height) && Objects.equals((Object)this.unitOfMeasure, (Object)dimensions.unitOfMeasure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.length, this.width, this.height, this.unitOfMeasure});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Dimensions {\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString((Object)this.unitOfMeasure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitOfMeasureEnum {
        IN("In"),
        FT("Ft"),
        METER("Meter"),
        YARD("Yard");

        private String value;

        private UnitOfMeasureEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitOfMeasureEnum fromValue(String input) {
            for (UnitOfMeasureEnum b : UnitOfMeasureEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UnitOfMeasureEnum> {
            public void write(JsonWriter jsonWriter, UnitOfMeasureEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public UnitOfMeasureEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitOfMeasureEnum.fromValue(value);
            }
        }
    }
}

