/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.ContainerIdentification;
import software.amazon.spapi.models.vendor.shipments.v1.Dimensions;
import software.amazon.spapi.models.vendor.shipments.v1.InnerContainersDetails;
import software.amazon.spapi.models.vendor.shipments.v1.PackedItems;
import software.amazon.spapi.models.vendor.shipments.v1.Weight;

@Schema(description="A list of the items in this transportation and their associated inner container details. If any of the item detail fields are common at a carton or a pallet level, provide them at the corresponding carton or pallet level.")
public class Containers {
    @SerializedName(value="containerType")
    private ContainerTypeEnum containerType = null;
    @SerializedName(value="containerSequenceNumber")
    private String containerSequenceNumber = null;
    @SerializedName(value="containerIdentifiers")
    private List<ContainerIdentification> containerIdentifiers = new ArrayList<ContainerIdentification>();
    @SerializedName(value="trackingNumber")
    private String trackingNumber = null;
    @SerializedName(value="dimensions")
    private Dimensions dimensions = null;
    @SerializedName(value="weight")
    private Weight weight = null;
    @SerializedName(value="tier")
    private Integer tier = null;
    @SerializedName(value="block")
    private Integer block = null;
    @SerializedName(value="innerContainersDetails")
    private InnerContainersDetails innerContainersDetails = null;
    @SerializedName(value="packedItems")
    private List<PackedItems> packedItems = null;

    public Containers containerType(ContainerTypeEnum containerType) {
        this.containerType = containerType;
        return this;
    }

    @Schema(required=true, description="The type of container.")
    public ContainerTypeEnum getContainerType() {
        return this.containerType;
    }

    public void setContainerType(ContainerTypeEnum containerType) {
        this.containerType = containerType;
    }

    public Containers containerSequenceNumber(String containerSequenceNumber) {
        this.containerSequenceNumber = containerSequenceNumber;
        return this;
    }

    @Schema(description="An integer that must be submitted for multi-box shipments only, where one item may come in separate packages.")
    public String getContainerSequenceNumber() {
        return this.containerSequenceNumber;
    }

    public void setContainerSequenceNumber(String containerSequenceNumber) {
        this.containerSequenceNumber = containerSequenceNumber;
    }

    public Containers containerIdentifiers(List<ContainerIdentification> containerIdentifiers) {
        this.containerIdentifiers = containerIdentifiers;
        return this;
    }

    public Containers addContainerIdentifiersItem(ContainerIdentification containerIdentifiersItem) {
        this.containerIdentifiers.add(containerIdentifiersItem);
        return this;
    }

    @Schema(required=true, description="A list of carton identifiers.")
    public List<ContainerIdentification> getContainerIdentifiers() {
        return this.containerIdentifiers;
    }

    public void setContainerIdentifiers(List<ContainerIdentification> containerIdentifiers) {
        this.containerIdentifiers = containerIdentifiers;
    }

    public Containers trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @Schema(description="The tracking number used for identifying the shipment.")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public Containers dimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @Schema(description="")
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public Containers weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @Schema(description="")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public Containers tier(Integer tier) {
        this.tier = tier;
        return this;
    }

    @Schema(description="Number of layers per pallet.")
    public Integer getTier() {
        return this.tier;
    }

    public void setTier(Integer tier) {
        this.tier = tier;
    }

    public Containers block(Integer block) {
        this.block = block;
        return this;
    }

    @Schema(description="Number of cartons per layer on the pallet.")
    public Integer getBlock() {
        return this.block;
    }

    public void setBlock(Integer block) {
        this.block = block;
    }

    public Containers innerContainersDetails(InnerContainersDetails innerContainersDetails) {
        this.innerContainersDetails = innerContainersDetails;
        return this;
    }

    @Schema(description="")
    public InnerContainersDetails getInnerContainersDetails() {
        return this.innerContainersDetails;
    }

    public void setInnerContainersDetails(InnerContainersDetails innerContainersDetails) {
        this.innerContainersDetails = innerContainersDetails;
    }

    public Containers packedItems(List<PackedItems> packedItems) {
        this.packedItems = packedItems;
        return this;
    }

    public Containers addPackedItemsItem(PackedItems packedItemsItem) {
        if (this.packedItems == null) {
            this.packedItems = new ArrayList<PackedItems>();
        }
        this.packedItems.add(packedItemsItem);
        return this;
    }

    @Schema(description="A list of packed items.")
    public List<PackedItems> getPackedItems() {
        return this.packedItems;
    }

    public void setPackedItems(List<PackedItems> packedItems) {
        this.packedItems = packedItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Containers containers = (Containers)o;
        return Objects.equals((Object)this.containerType, (Object)containers.containerType) && Objects.equals(this.containerSequenceNumber, containers.containerSequenceNumber) && Objects.equals(this.containerIdentifiers, containers.containerIdentifiers) && Objects.equals(this.trackingNumber, containers.trackingNumber) && Objects.equals(this.dimensions, containers.dimensions) && Objects.equals(this.weight, containers.weight) && Objects.equals(this.tier, containers.tier) && Objects.equals(this.block, containers.block) && Objects.equals(this.innerContainersDetails, containers.innerContainersDetails) && Objects.equals(this.packedItems, containers.packedItems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerType, this.containerSequenceNumber, this.containerIdentifiers, this.trackingNumber, this.dimensions, this.weight, this.tier, this.block, this.innerContainersDetails, this.packedItems});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Containers {\n");
        sb.append("    containerType: ").append(this.toIndentedString((Object)this.containerType)).append("\n");
        sb.append("    containerSequenceNumber: ").append(this.toIndentedString(this.containerSequenceNumber)).append("\n");
        sb.append("    containerIdentifiers: ").append(this.toIndentedString(this.containerIdentifiers)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    tier: ").append(this.toIndentedString(this.tier)).append("\n");
        sb.append("    block: ").append(this.toIndentedString(this.block)).append("\n");
        sb.append("    innerContainersDetails: ").append(this.toIndentedString(this.innerContainersDetails)).append("\n");
        sb.append("    packedItems: ").append(this.toIndentedString(this.packedItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContainerTypeEnum {
        CARTON("carton"),
        PALLET("pallet");

        private String value;

        private ContainerTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContainerTypeEnum fromValue(String input) {
            for (ContainerTypeEnum b : ContainerTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ContainerTypeEnum> {
            public void write(JsonWriter jsonWriter, ContainerTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ContainerTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContainerTypeEnum.fromValue(value);
            }
        }
    }
}

