/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.ItemDetails;
import software.amazon.spapi.models.vendor.shipments.v1.ItemQuantity;

@Schema(description="Carton/Pallet level details for the item.")
public class ContainerItem {
    @SerializedName(value="itemReference")
    private String itemReference = null;
    @SerializedName(value="shippedQuantity")
    private ItemQuantity shippedQuantity = null;
    @SerializedName(value="itemDetails")
    private ItemDetails itemDetails = null;

    public ContainerItem itemReference(String itemReference) {
        this.itemReference = itemReference;
        return this;
    }

    @Schema(required=true, description="The reference number for the item. Please provide the itemSequenceNumber from the 'items' segment to refer to that item's details here.")
    public String getItemReference() {
        return this.itemReference;
    }

    public void setItemReference(String itemReference) {
        this.itemReference = itemReference;
    }

    public ContainerItem shippedQuantity(ItemQuantity shippedQuantity) {
        this.shippedQuantity = shippedQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public ItemQuantity getShippedQuantity() {
        return this.shippedQuantity;
    }

    public void setShippedQuantity(ItemQuantity shippedQuantity) {
        this.shippedQuantity = shippedQuantity;
    }

    public ContainerItem itemDetails(ItemDetails itemDetails) {
        this.itemDetails = itemDetails;
        return this;
    }

    @Schema(description="")
    public ItemDetails getItemDetails() {
        return this.itemDetails;
    }

    public void setItemDetails(ItemDetails itemDetails) {
        this.itemDetails = itemDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerItem containerItem = (ContainerItem)o;
        return Objects.equals(this.itemReference, containerItem.itemReference) && Objects.equals(this.shippedQuantity, containerItem.shippedQuantity) && Objects.equals(this.itemDetails, containerItem.itemDetails);
    }

    public int hashCode() {
        return Objects.hash(this.itemReference, this.shippedQuantity, this.itemDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerItem {\n");
        sb.append("    itemReference: ").append(this.toIndentedString(this.itemReference)).append("\n");
        sb.append("    shippedQuantity: ").append(this.toIndentedString(this.shippedQuantity)).append("\n");
        sb.append("    itemDetails: ").append(this.toIndentedString(this.itemDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

