/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Carton reference details.")
public class CartonReferenceDetails {
    @SerializedName(value="cartonCount")
    private Integer cartonCount = null;
    @SerializedName(value="cartonReferenceNumbers")
    private List<String> cartonReferenceNumbers = new ArrayList<String>();

    public CartonReferenceDetails cartonCount(Integer cartonCount) {
        this.cartonCount = cartonCount;
        return this;
    }

    @Schema(description="Pallet level carton count is mandatory for single item pallet and optional for mixed item pallet.")
    public Integer getCartonCount() {
        return this.cartonCount;
    }

    public void setCartonCount(Integer cartonCount) {
        this.cartonCount = cartonCount;
    }

    public CartonReferenceDetails cartonReferenceNumbers(List<String> cartonReferenceNumbers) {
        this.cartonReferenceNumbers = cartonReferenceNumbers;
        return this;
    }

    public CartonReferenceDetails addCartonReferenceNumbersItem(String cartonReferenceNumbersItem) {
        this.cartonReferenceNumbers.add(cartonReferenceNumbersItem);
        return this;
    }

    @Schema(required=true, description="Array of reference numbers for the carton that are part of this pallet/shipment. Please provide the cartonSequenceNumber from the 'cartons' segment to refer to that carton's details here.")
    public List<String> getCartonReferenceNumbers() {
        return this.cartonReferenceNumbers;
    }

    public void setCartonReferenceNumbers(List<String> cartonReferenceNumbers) {
        this.cartonReferenceNumbers = cartonReferenceNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CartonReferenceDetails cartonReferenceDetails = (CartonReferenceDetails)o;
        return Objects.equals(this.cartonCount, cartonReferenceDetails.cartonCount) && Objects.equals(this.cartonReferenceNumbers, cartonReferenceDetails.cartonReferenceNumbers);
    }

    public int hashCode() {
        return Objects.hash(this.cartonCount, this.cartonReferenceNumbers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CartonReferenceDetails {\n");
        sb.append("    cartonCount: ").append(this.toIndentedString(this.cartonCount)).append("\n");
        sb.append("    cartonReferenceNumbers: ").append(this.toIndentedString(this.cartonReferenceNumbers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

