/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.ContainerIdentification;
import software.amazon.spapi.models.vendor.shipments.v1.ContainerItem;
import software.amazon.spapi.models.vendor.shipments.v1.Dimensions;
import software.amazon.spapi.models.vendor.shipments.v1.Weight;

@Schema(description="Details of the carton/package being shipped.")
public class Carton {
    @SerializedName(value="cartonIdentifiers")
    private List<ContainerIdentification> cartonIdentifiers = null;
    @SerializedName(value="cartonSequenceNumber")
    private String cartonSequenceNumber = null;
    @SerializedName(value="dimensions")
    private Dimensions dimensions = null;
    @SerializedName(value="weight")
    private Weight weight = null;
    @SerializedName(value="trackingNumber")
    private String trackingNumber = null;
    @SerializedName(value="items")
    private List<ContainerItem> items = new ArrayList<ContainerItem>();

    public Carton cartonIdentifiers(List<ContainerIdentification> cartonIdentifiers) {
        this.cartonIdentifiers = cartonIdentifiers;
        return this;
    }

    public Carton addCartonIdentifiersItem(ContainerIdentification cartonIdentifiersItem) {
        if (this.cartonIdentifiers == null) {
            this.cartonIdentifiers = new ArrayList<ContainerIdentification>();
        }
        this.cartonIdentifiers.add(cartonIdentifiersItem);
        return this;
    }

    @Schema(description="A list of carton identifiers.")
    public List<ContainerIdentification> getCartonIdentifiers() {
        return this.cartonIdentifiers;
    }

    public void setCartonIdentifiers(List<ContainerIdentification> cartonIdentifiers) {
        this.cartonIdentifiers = cartonIdentifiers;
    }

    public Carton cartonSequenceNumber(String cartonSequenceNumber) {
        this.cartonSequenceNumber = cartonSequenceNumber;
        return this;
    }

    @Schema(required=true, description="Carton sequence number for the carton. The first carton will be 001, the second 002, and so on. This number is used as a reference to refer to this carton from the pallet level.")
    public String getCartonSequenceNumber() {
        return this.cartonSequenceNumber;
    }

    public void setCartonSequenceNumber(String cartonSequenceNumber) {
        this.cartonSequenceNumber = cartonSequenceNumber;
    }

    public Carton dimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @Schema(description="")
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public Carton weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @Schema(description="")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public Carton trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @Schema(description="This is required to be provided for every carton in the small parcel shipments.")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public Carton items(List<ContainerItem> items) {
        this.items = items;
        return this;
    }

    public Carton addItemsItem(ContainerItem itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Schema(required=true, description="A list of container item details.")
    public List<ContainerItem> getItems() {
        return this.items;
    }

    public void setItems(List<ContainerItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Carton carton = (Carton)o;
        return Objects.equals(this.cartonIdentifiers, carton.cartonIdentifiers) && Objects.equals(this.cartonSequenceNumber, carton.cartonSequenceNumber) && Objects.equals(this.dimensions, carton.dimensions) && Objects.equals(this.weight, carton.weight) && Objects.equals(this.trackingNumber, carton.trackingNumber) && Objects.equals(this.items, carton.items);
    }

    public int hashCode() {
        return Objects.hash(this.cartonIdentifiers, this.cartonSequenceNumber, this.dimensions, this.weight, this.trackingNumber, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Carton {\n");
        sb.append("    cartonIdentifiers: ").append(this.toIndentedString(this.cartonIdentifiers)).append("\n");
        sb.append("    cartonSequenceNumber: ").append(this.toIndentedString(this.cartonSequenceNumber)).append("\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

