/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Indicates the carrier details and their contact informations")
public class CarrierDetails {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="code")
    private String code = null;
    @SerializedName(value="phone")
    private String phone = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="shipmentReferenceNumber")
    private String shipmentReferenceNumber = null;

    public CarrierDetails name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The field is used to represent the carrier used for performing the shipment.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CarrierDetails code(String code) {
        this.code = code;
        return this;
    }

    @Schema(description="Code that identifies the carrier for the shipment. The Standard Carrier Alpha Code (SCAC) is a unique two to four letter code used to identify a carrier. Carrier SCAC codes are assigned and maintained by the NMFTA (National Motor Freight Association).")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public CarrierDetails phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Schema(description="The field is used to represent the Carrier contact number.")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public CarrierDetails email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="The field is used to represent the carrier Email id.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CarrierDetails shipmentReferenceNumber(String shipmentReferenceNumber) {
        this.shipmentReferenceNumber = shipmentReferenceNumber;
        return this;
    }

    @Schema(description="The field is also known as PRO number is a unique number assigned by the carrier. It is used to identify and track the shipment that goes out for delivery. This field is mandatory for US, CA, MX shipment confirmations.")
    public String getShipmentReferenceNumber() {
        return this.shipmentReferenceNumber;
    }

    public void setShipmentReferenceNumber(String shipmentReferenceNumber) {
        this.shipmentReferenceNumber = shipmentReferenceNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CarrierDetails carrierDetails = (CarrierDetails)o;
        return Objects.equals(this.name, carrierDetails.name) && Objects.equals(this.code, carrierDetails.code) && Objects.equals(this.phone, carrierDetails.phone) && Objects.equals(this.email, carrierDetails.email) && Objects.equals(this.shipmentReferenceNumber, carrierDetails.shipmentReferenceNumber);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.code, this.phone, this.email, this.shipmentReferenceNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CarrierDetails {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    shipmentReferenceNumber: ").append(this.toIndentedString(this.shipmentReferenceNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

