/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.orders.v1.ItemQuantity;

@Schema(description="Details of item quantity ordered.")
public class OrderedQuantityDetails {
    @SerializedName(value="updatedDate")
    private OffsetDateTime updatedDate = null;
    @SerializedName(value="orderedQuantity")
    private ItemQuantity orderedQuantity = null;
    @SerializedName(value="cancelledQuantity")
    private ItemQuantity cancelledQuantity = null;

    public OrderedQuantityDetails updatedDate(OffsetDateTime updatedDate) {
        this.updatedDate = updatedDate;
        return this;
    }

    @Schema(description="The date when the line item quantity was updated by buyer. Must be in ISO-8601 date/time format.")
    public OffsetDateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(OffsetDateTime updatedDate) {
        this.updatedDate = updatedDate;
    }

    public OrderedQuantityDetails orderedQuantity(ItemQuantity orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
        return this;
    }

    @Schema(description="")
    public ItemQuantity getOrderedQuantity() {
        return this.orderedQuantity;
    }

    public void setOrderedQuantity(ItemQuantity orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
    }

    public OrderedQuantityDetails cancelledQuantity(ItemQuantity cancelledQuantity) {
        this.cancelledQuantity = cancelledQuantity;
        return this;
    }

    @Schema(description="")
    public ItemQuantity getCancelledQuantity() {
        return this.cancelledQuantity;
    }

    public void setCancelledQuantity(ItemQuantity cancelledQuantity) {
        this.cancelledQuantity = cancelledQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedQuantityDetails orderedQuantityDetails = (OrderedQuantityDetails)o;
        return Objects.equals(this.updatedDate, orderedQuantityDetails.updatedDate) && Objects.equals(this.orderedQuantity, orderedQuantityDetails.orderedQuantity) && Objects.equals(this.cancelledQuantity, orderedQuantityDetails.cancelledQuantity);
    }

    public int hashCode() {
        return Objects.hash(this.updatedDate, this.orderedQuantity, this.cancelledQuantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderedQuantityDetails {\n");
        sb.append("    updatedDate: ").append(this.toIndentedString(this.updatedDate)).append("\n");
        sb.append("    orderedQuantity: ").append(this.toIndentedString(this.orderedQuantity)).append("\n");
        sb.append("    cancelledQuantity: ").append(this.toIndentedString(this.cancelledQuantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

