/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.orders.v1.ItemStatus;
import software.amazon.spapi.models.vendor.orders.v1.PartyIdentification;

@Schema(description="Current status of a purchase order.")
public class OrderStatus {
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="purchaseOrderStatus")
    private PurchaseOrderStatusEnum purchaseOrderStatus = null;
    @SerializedName(value="purchaseOrderDate")
    private OffsetDateTime purchaseOrderDate = null;
    @SerializedName(value="lastUpdatedDate")
    private OffsetDateTime lastUpdatedDate = null;
    @SerializedName(value="sellingParty")
    private PartyIdentification sellingParty = null;
    @SerializedName(value="shipToParty")
    private PartyIdentification shipToParty = null;
    @SerializedName(value="itemStatus")
    private ItemStatus itemStatus = null;

    public OrderStatus purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(required=true, description="The buyer's purchase order number for this order. Formatting Notes: 8-character alpha-numeric code.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public OrderStatus purchaseOrderStatus(PurchaseOrderStatusEnum purchaseOrderStatus) {
        this.purchaseOrderStatus = purchaseOrderStatus;
        return this;
    }

    @Schema(required=true, description="The status of the buyer's purchase order for this order.")
    public PurchaseOrderStatusEnum getPurchaseOrderStatus() {
        return this.purchaseOrderStatus;
    }

    public void setPurchaseOrderStatus(PurchaseOrderStatusEnum purchaseOrderStatus) {
        this.purchaseOrderStatus = purchaseOrderStatus;
    }

    public OrderStatus purchaseOrderDate(OffsetDateTime purchaseOrderDate) {
        this.purchaseOrderDate = purchaseOrderDate;
        return this;
    }

    @Schema(required=true, description="The date the purchase order was placed. Must be in ISO-8601 date/time format.")
    public OffsetDateTime getPurchaseOrderDate() {
        return this.purchaseOrderDate;
    }

    public void setPurchaseOrderDate(OffsetDateTime purchaseOrderDate) {
        this.purchaseOrderDate = purchaseOrderDate;
    }

    public OrderStatus lastUpdatedDate(OffsetDateTime lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
        return this;
    }

    @Schema(description="The date when the purchase order was last updated. Must be in ISO-8601 date/time format.")
    public OffsetDateTime getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(OffsetDateTime lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public OrderStatus sellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getSellingParty() {
        return this.sellingParty;
    }

    public void setSellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
    }

    public OrderStatus shipToParty(PartyIdentification shipToParty) {
        this.shipToParty = shipToParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getShipToParty() {
        return this.shipToParty;
    }

    public void setShipToParty(PartyIdentification shipToParty) {
        this.shipToParty = shipToParty;
    }

    public OrderStatus itemStatus(ItemStatus itemStatus) {
        this.itemStatus = itemStatus;
        return this;
    }

    @Schema(required=true, description="")
    public ItemStatus getItemStatus() {
        return this.itemStatus;
    }

    public void setItemStatus(ItemStatus itemStatus) {
        this.itemStatus = itemStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderStatus orderStatus = (OrderStatus)o;
        return Objects.equals(this.purchaseOrderNumber, orderStatus.purchaseOrderNumber) && Objects.equals((Object)this.purchaseOrderStatus, (Object)orderStatus.purchaseOrderStatus) && Objects.equals(this.purchaseOrderDate, orderStatus.purchaseOrderDate) && Objects.equals(this.lastUpdatedDate, orderStatus.lastUpdatedDate) && Objects.equals(this.sellingParty, orderStatus.sellingParty) && Objects.equals(this.shipToParty, orderStatus.shipToParty) && Objects.equals(this.itemStatus, orderStatus.itemStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.purchaseOrderNumber, this.purchaseOrderStatus, this.purchaseOrderDate, this.lastUpdatedDate, this.sellingParty, this.shipToParty, this.itemStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderStatus {\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    purchaseOrderStatus: ").append(this.toIndentedString((Object)this.purchaseOrderStatus)).append("\n");
        sb.append("    purchaseOrderDate: ").append(this.toIndentedString(this.purchaseOrderDate)).append("\n");
        sb.append("    lastUpdatedDate: ").append(this.toIndentedString(this.lastUpdatedDate)).append("\n");
        sb.append("    sellingParty: ").append(this.toIndentedString(this.sellingParty)).append("\n");
        sb.append("    shipToParty: ").append(this.toIndentedString(this.shipToParty)).append("\n");
        sb.append("    itemStatus: ").append(this.toIndentedString(this.itemStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PurchaseOrderStatusEnum {
        OPEN("OPEN"),
        CLOSED("CLOSED");

        private String value;

        private PurchaseOrderStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PurchaseOrderStatusEnum fromValue(String input) {
            for (PurchaseOrderStatusEnum b : PurchaseOrderStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PurchaseOrderStatusEnum> {
            public void write(JsonWriter jsonWriter, PurchaseOrderStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public PurchaseOrderStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PurchaseOrderStatusEnum.fromValue(value);
            }
        }
    }
}

