/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.orders.v1.AcknowledgementStatusDetails;
import software.amazon.spapi.models.vendor.orders.v1.ItemQuantity;

@Schema(description="Acknowledgement status information.")
public class OrderItemStatusAcknowledgementStatus {
    @SerializedName(value="confirmationStatus")
    private ConfirmationStatusEnum confirmationStatus = null;
    @SerializedName(value="acceptedQuantity")
    private ItemQuantity acceptedQuantity = null;
    @SerializedName(value="rejectedQuantity")
    private ItemQuantity rejectedQuantity = null;
    @SerializedName(value="acknowledgementStatusDetails")
    private List<AcknowledgementStatusDetails> acknowledgementStatusDetails = null;

    public OrderItemStatusAcknowledgementStatus confirmationStatus(ConfirmationStatusEnum confirmationStatus) {
        this.confirmationStatus = confirmationStatus;
        return this;
    }

    @Schema(description="Confirmation status of line item.")
    public ConfirmationStatusEnum getConfirmationStatus() {
        return this.confirmationStatus;
    }

    public void setConfirmationStatus(ConfirmationStatusEnum confirmationStatus) {
        this.confirmationStatus = confirmationStatus;
    }

    public OrderItemStatusAcknowledgementStatus acceptedQuantity(ItemQuantity acceptedQuantity) {
        this.acceptedQuantity = acceptedQuantity;
        return this;
    }

    @Schema(description="")
    public ItemQuantity getAcceptedQuantity() {
        return this.acceptedQuantity;
    }

    public void setAcceptedQuantity(ItemQuantity acceptedQuantity) {
        this.acceptedQuantity = acceptedQuantity;
    }

    public OrderItemStatusAcknowledgementStatus rejectedQuantity(ItemQuantity rejectedQuantity) {
        this.rejectedQuantity = rejectedQuantity;
        return this;
    }

    @Schema(description="")
    public ItemQuantity getRejectedQuantity() {
        return this.rejectedQuantity;
    }

    public void setRejectedQuantity(ItemQuantity rejectedQuantity) {
        this.rejectedQuantity = rejectedQuantity;
    }

    public OrderItemStatusAcknowledgementStatus acknowledgementStatusDetails(List<AcknowledgementStatusDetails> acknowledgementStatusDetails) {
        this.acknowledgementStatusDetails = acknowledgementStatusDetails;
        return this;
    }

    public OrderItemStatusAcknowledgementStatus addAcknowledgementStatusDetailsItem(AcknowledgementStatusDetails acknowledgementStatusDetailsItem) {
        if (this.acknowledgementStatusDetails == null) {
            this.acknowledgementStatusDetails = new ArrayList<AcknowledgementStatusDetails>();
        }
        this.acknowledgementStatusDetails.add(acknowledgementStatusDetailsItem);
        return this;
    }

    @Schema(description="Details of item quantity confirmed.")
    public List<AcknowledgementStatusDetails> getAcknowledgementStatusDetails() {
        return this.acknowledgementStatusDetails;
    }

    public void setAcknowledgementStatusDetails(List<AcknowledgementStatusDetails> acknowledgementStatusDetails) {
        this.acknowledgementStatusDetails = acknowledgementStatusDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItemStatusAcknowledgementStatus orderItemStatusAcknowledgementStatus = (OrderItemStatusAcknowledgementStatus)o;
        return Objects.equals((Object)this.confirmationStatus, (Object)orderItemStatusAcknowledgementStatus.confirmationStatus) && Objects.equals(this.acceptedQuantity, orderItemStatusAcknowledgementStatus.acceptedQuantity) && Objects.equals(this.rejectedQuantity, orderItemStatusAcknowledgementStatus.rejectedQuantity) && Objects.equals(this.acknowledgementStatusDetails, orderItemStatusAcknowledgementStatus.acknowledgementStatusDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.confirmationStatus, this.acceptedQuantity, this.rejectedQuantity, this.acknowledgementStatusDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderItemStatusAcknowledgementStatus {\n");
        sb.append("    confirmationStatus: ").append(this.toIndentedString((Object)this.confirmationStatus)).append("\n");
        sb.append("    acceptedQuantity: ").append(this.toIndentedString(this.acceptedQuantity)).append("\n");
        sb.append("    rejectedQuantity: ").append(this.toIndentedString(this.rejectedQuantity)).append("\n");
        sb.append("    acknowledgementStatusDetails: ").append(this.toIndentedString(this.acknowledgementStatusDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ConfirmationStatusEnum {
        ACCEPTED("ACCEPTED"),
        PARTIALLY_ACCEPTED("PARTIALLY_ACCEPTED"),
        REJECTED("REJECTED"),
        UNCONFIRMED("UNCONFIRMED");

        private String value;

        private ConfirmationStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ConfirmationStatusEnum fromValue(String input) {
            for (ConfirmationStatusEnum b : ConfirmationStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ConfirmationStatusEnum> {
            public void write(JsonWriter jsonWriter, ConfirmationStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ConfirmationStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ConfirmationStatusEnum.fromValue(value);
            }
        }
    }
}

