/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.orders.v1.Money;
import software.amazon.spapi.models.vendor.orders.v1.OrderItemStatusAcknowledgementStatus;
import software.amazon.spapi.models.vendor.orders.v1.OrderItemStatusOrderedQuantity;
import software.amazon.spapi.models.vendor.orders.v1.OrderItemStatusReceivingStatus;

@Schema(description="Represents the current status of an order item, including acknowledgement and receiving details.")
public class OrderItemStatus {
    @SerializedName(value="itemSequenceNumber")
    private String itemSequenceNumber = null;
    @SerializedName(value="buyerProductIdentifier")
    private String buyerProductIdentifier = null;
    @SerializedName(value="vendorProductIdentifier")
    private String vendorProductIdentifier = null;
    @SerializedName(value="netCost")
    private Money netCost = null;
    @SerializedName(value="listPrice")
    private Money listPrice = null;
    @SerializedName(value="orderedQuantity")
    private OrderItemStatusOrderedQuantity orderedQuantity = null;
    @SerializedName(value="acknowledgementStatus")
    private OrderItemStatusAcknowledgementStatus acknowledgementStatus = null;
    @SerializedName(value="receivingStatus")
    private OrderItemStatusReceivingStatus receivingStatus = null;

    public OrderItemStatus itemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
        return this;
    }

    @Schema(required=true, description="Numbering of the item on the purchase order. The first item will be 1, the second 2, and so on.")
    public String getItemSequenceNumber() {
        return this.itemSequenceNumber;
    }

    public void setItemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
    }

    public OrderItemStatus buyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
        return this;
    }

    @Schema(description="Buyer's Standard Identification Number (ASIN) of an item.")
    public String getBuyerProductIdentifier() {
        return this.buyerProductIdentifier;
    }

    public void setBuyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
    }

    public OrderItemStatus vendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
        return this;
    }

    @Schema(description="The vendor selected product identification of the item.")
    public String getVendorProductIdentifier() {
        return this.vendorProductIdentifier;
    }

    public void setVendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
    }

    public OrderItemStatus netCost(Money netCost) {
        this.netCost = netCost;
        return this;
    }

    @Schema(description="")
    public Money getNetCost() {
        return this.netCost;
    }

    public void setNetCost(Money netCost) {
        this.netCost = netCost;
    }

    public OrderItemStatus listPrice(Money listPrice) {
        this.listPrice = listPrice;
        return this;
    }

    @Schema(description="")
    public Money getListPrice() {
        return this.listPrice;
    }

    public void setListPrice(Money listPrice) {
        this.listPrice = listPrice;
    }

    public OrderItemStatus orderedQuantity(OrderItemStatusOrderedQuantity orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
        return this;
    }

    @Schema(description="")
    public OrderItemStatusOrderedQuantity getOrderedQuantity() {
        return this.orderedQuantity;
    }

    public void setOrderedQuantity(OrderItemStatusOrderedQuantity orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
    }

    public OrderItemStatus acknowledgementStatus(OrderItemStatusAcknowledgementStatus acknowledgementStatus) {
        this.acknowledgementStatus = acknowledgementStatus;
        return this;
    }

    @Schema(description="")
    public OrderItemStatusAcknowledgementStatus getAcknowledgementStatus() {
        return this.acknowledgementStatus;
    }

    public void setAcknowledgementStatus(OrderItemStatusAcknowledgementStatus acknowledgementStatus) {
        this.acknowledgementStatus = acknowledgementStatus;
    }

    public OrderItemStatus receivingStatus(OrderItemStatusReceivingStatus receivingStatus) {
        this.receivingStatus = receivingStatus;
        return this;
    }

    @Schema(description="")
    public OrderItemStatusReceivingStatus getReceivingStatus() {
        return this.receivingStatus;
    }

    public void setReceivingStatus(OrderItemStatusReceivingStatus receivingStatus) {
        this.receivingStatus = receivingStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItemStatus orderItemStatus = (OrderItemStatus)o;
        return Objects.equals(this.itemSequenceNumber, orderItemStatus.itemSequenceNumber) && Objects.equals(this.buyerProductIdentifier, orderItemStatus.buyerProductIdentifier) && Objects.equals(this.vendorProductIdentifier, orderItemStatus.vendorProductIdentifier) && Objects.equals(this.netCost, orderItemStatus.netCost) && Objects.equals(this.listPrice, orderItemStatus.listPrice) && Objects.equals(this.orderedQuantity, orderItemStatus.orderedQuantity) && Objects.equals(this.acknowledgementStatus, orderItemStatus.acknowledgementStatus) && Objects.equals(this.receivingStatus, orderItemStatus.receivingStatus);
    }

    public int hashCode() {
        return Objects.hash(this.itemSequenceNumber, this.buyerProductIdentifier, this.vendorProductIdentifier, this.netCost, this.listPrice, this.orderedQuantity, this.acknowledgementStatus, this.receivingStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderItemStatus {\n");
        sb.append("    itemSequenceNumber: ").append(this.toIndentedString(this.itemSequenceNumber)).append("\n");
        sb.append("    buyerProductIdentifier: ").append(this.toIndentedString(this.buyerProductIdentifier)).append("\n");
        sb.append("    vendorProductIdentifier: ").append(this.toIndentedString(this.vendorProductIdentifier)).append("\n");
        sb.append("    netCost: ").append(this.toIndentedString(this.netCost)).append("\n");
        sb.append("    listPrice: ").append(this.toIndentedString(this.listPrice)).append("\n");
        sb.append("    orderedQuantity: ").append(this.toIndentedString(this.orderedQuantity)).append("\n");
        sb.append("    acknowledgementStatus: ").append(this.toIndentedString(this.acknowledgementStatus)).append("\n");
        sb.append("    receivingStatus: ").append(this.toIndentedString(this.receivingStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

