/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.orders.v1.ItemQuantity;

@Schema(description="Represents the acknowledgement details for an individual order item, including the acknowledgement code, acknowledged quantity, scheduled ship and delivery dates, and rejection reason (if applicable).")
public class OrderItemAcknowledgement {
    @SerializedName(value="acknowledgementCode")
    private AcknowledgementCodeEnum acknowledgementCode = null;
    @SerializedName(value="acknowledgedQuantity")
    private ItemQuantity acknowledgedQuantity = null;
    @SerializedName(value="scheduledShipDate")
    private OffsetDateTime scheduledShipDate = null;
    @SerializedName(value="scheduledDeliveryDate")
    private OffsetDateTime scheduledDeliveryDate = null;
    @SerializedName(value="rejectionReason")
    private RejectionReasonEnum rejectionReason = null;

    public OrderItemAcknowledgement acknowledgementCode(AcknowledgementCodeEnum acknowledgementCode) {
        this.acknowledgementCode = acknowledgementCode;
        return this;
    }

    @Schema(required=true, description="This indicates the acknowledgement code.")
    public AcknowledgementCodeEnum getAcknowledgementCode() {
        return this.acknowledgementCode;
    }

    public void setAcknowledgementCode(AcknowledgementCodeEnum acknowledgementCode) {
        this.acknowledgementCode = acknowledgementCode;
    }

    public OrderItemAcknowledgement acknowledgedQuantity(ItemQuantity acknowledgedQuantity) {
        this.acknowledgedQuantity = acknowledgedQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public ItemQuantity getAcknowledgedQuantity() {
        return this.acknowledgedQuantity;
    }

    public void setAcknowledgedQuantity(ItemQuantity acknowledgedQuantity) {
        this.acknowledgedQuantity = acknowledgedQuantity;
    }

    public OrderItemAcknowledgement scheduledShipDate(OffsetDateTime scheduledShipDate) {
        this.scheduledShipDate = scheduledShipDate;
        return this;
    }

    @Schema(description="Estimated ship date per line item. Must be in ISO-8601 date/time format.")
    public OffsetDateTime getScheduledShipDate() {
        return this.scheduledShipDate;
    }

    public void setScheduledShipDate(OffsetDateTime scheduledShipDate) {
        this.scheduledShipDate = scheduledShipDate;
    }

    public OrderItemAcknowledgement scheduledDeliveryDate(OffsetDateTime scheduledDeliveryDate) {
        this.scheduledDeliveryDate = scheduledDeliveryDate;
        return this;
    }

    @Schema(description="Estimated delivery date per line item. Must be in ISO-8601 date/time format.")
    public OffsetDateTime getScheduledDeliveryDate() {
        return this.scheduledDeliveryDate;
    }

    public void setScheduledDeliveryDate(OffsetDateTime scheduledDeliveryDate) {
        this.scheduledDeliveryDate = scheduledDeliveryDate;
    }

    public OrderItemAcknowledgement rejectionReason(RejectionReasonEnum rejectionReason) {
        this.rejectionReason = rejectionReason;
        return this;
    }

    @Schema(description="Indicates the reason for rejection.")
    public RejectionReasonEnum getRejectionReason() {
        return this.rejectionReason;
    }

    public void setRejectionReason(RejectionReasonEnum rejectionReason) {
        this.rejectionReason = rejectionReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItemAcknowledgement orderItemAcknowledgement = (OrderItemAcknowledgement)o;
        return Objects.equals((Object)this.acknowledgementCode, (Object)orderItemAcknowledgement.acknowledgementCode) && Objects.equals(this.acknowledgedQuantity, orderItemAcknowledgement.acknowledgedQuantity) && Objects.equals(this.scheduledShipDate, orderItemAcknowledgement.scheduledShipDate) && Objects.equals(this.scheduledDeliveryDate, orderItemAcknowledgement.scheduledDeliveryDate) && Objects.equals((Object)this.rejectionReason, (Object)orderItemAcknowledgement.rejectionReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acknowledgementCode, this.acknowledgedQuantity, this.scheduledShipDate, this.scheduledDeliveryDate, this.rejectionReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderItemAcknowledgement {\n");
        sb.append("    acknowledgementCode: ").append(this.toIndentedString((Object)this.acknowledgementCode)).append("\n");
        sb.append("    acknowledgedQuantity: ").append(this.toIndentedString(this.acknowledgedQuantity)).append("\n");
        sb.append("    scheduledShipDate: ").append(this.toIndentedString(this.scheduledShipDate)).append("\n");
        sb.append("    scheduledDeliveryDate: ").append(this.toIndentedString(this.scheduledDeliveryDate)).append("\n");
        sb.append("    rejectionReason: ").append(this.toIndentedString((Object)this.rejectionReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RejectionReasonEnum {
        TEMPORARILYUNAVAILABLE("TemporarilyUnavailable"),
        INVALIDPRODUCTIDENTIFIER("InvalidProductIdentifier"),
        OBSOLETEPRODUCT("ObsoleteProduct");

        private String value;

        private RejectionReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RejectionReasonEnum fromValue(String input) {
            for (RejectionReasonEnum b : RejectionReasonEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RejectionReasonEnum> {
            public void write(JsonWriter jsonWriter, RejectionReasonEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public RejectionReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RejectionReasonEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AcknowledgementCodeEnum {
        ACCEPTED("Accepted"),
        BACKORDERED("Backordered"),
        REJECTED("Rejected");

        private String value;

        private AcknowledgementCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AcknowledgementCodeEnum fromValue(String input) {
            for (AcknowledgementCodeEnum b : AcknowledgementCodeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AcknowledgementCodeEnum> {
            public void write(JsonWriter jsonWriter, AcknowledgementCodeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public AcknowledgementCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AcknowledgementCodeEnum.fromValue(value);
            }
        }
    }
}

