/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Import details for an import order.")
public class ImportDetails {
    @SerializedName(value="methodOfPayment")
    private MethodOfPaymentEnum methodOfPayment = null;
    @SerializedName(value="internationalCommercialTerms")
    private InternationalCommercialTermsEnum internationalCommercialTerms = null;
    @SerializedName(value="portOfDelivery")
    private String portOfDelivery = null;
    @SerializedName(value="importContainers")
    private String importContainers = null;
    @SerializedName(value="shippingInstructions")
    private String shippingInstructions = null;

    public ImportDetails methodOfPayment(MethodOfPaymentEnum methodOfPayment) {
        this.methodOfPayment = methodOfPayment;
        return this;
    }

    @Schema(description="If the recipient requests, contains the shipment method of payment. This is for import PO's only.")
    public MethodOfPaymentEnum getMethodOfPayment() {
        return this.methodOfPayment;
    }

    public void setMethodOfPayment(MethodOfPaymentEnum methodOfPayment) {
        this.methodOfPayment = methodOfPayment;
    }

    public ImportDetails internationalCommercialTerms(InternationalCommercialTermsEnum internationalCommercialTerms) {
        this.internationalCommercialTerms = internationalCommercialTerms;
        return this;
    }

    @Schema(description="Incoterms (International Commercial Terms) are used to divide transaction costs and responsibilities between buyer and seller and reflect state-of-the-art transportation practices. This is for import purchase orders only. ")
    public InternationalCommercialTermsEnum getInternationalCommercialTerms() {
        return this.internationalCommercialTerms;
    }

    public void setInternationalCommercialTerms(InternationalCommercialTermsEnum internationalCommercialTerms) {
        this.internationalCommercialTerms = internationalCommercialTerms;
    }

    public ImportDetails portOfDelivery(String portOfDelivery) {
        this.portOfDelivery = portOfDelivery;
        return this;
    }

    @Schema(description="The port where goods on an import purchase order must be delivered by the vendor. This should only be specified when the internationalCommercialTerms is FOB.")
    public String getPortOfDelivery() {
        return this.portOfDelivery;
    }

    public void setPortOfDelivery(String portOfDelivery) {
        this.portOfDelivery = portOfDelivery;
    }

    public ImportDetails importContainers(String importContainers) {
        this.importContainers = importContainers;
        return this;
    }

    @Schema(description="Types and numbers of container(s) for import purchase orders. Can be a comma-separated list if the shipment has multiple containers. HC signifies a high-capacity container. Free-text field, limited to 64 characters. The format will be a comma-delimited list containing values of the type: $NUMBER_OF_CONTAINERS_OF_THIS_TYPE-$CONTAINER_TYPE. The list of values for the container type is: 40'(40-foot container), 40'HC (40-foot high-capacity container), 45', 45'HC, 30', 30'HC, 20', 20'HC.")
    public String getImportContainers() {
        return this.importContainers;
    }

    public void setImportContainers(String importContainers) {
        this.importContainers = importContainers;
    }

    public ImportDetails shippingInstructions(String shippingInstructions) {
        this.shippingInstructions = shippingInstructions;
        return this;
    }

    @Schema(description="Special instructions regarding the shipment. This field is for import purchase orders.")
    public String getShippingInstructions() {
        return this.shippingInstructions;
    }

    public void setShippingInstructions(String shippingInstructions) {
        this.shippingInstructions = shippingInstructions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportDetails importDetails = (ImportDetails)o;
        return Objects.equals((Object)this.methodOfPayment, (Object)importDetails.methodOfPayment) && Objects.equals((Object)this.internationalCommercialTerms, (Object)importDetails.internationalCommercialTerms) && Objects.equals(this.portOfDelivery, importDetails.portOfDelivery) && Objects.equals(this.importContainers, importDetails.importContainers) && Objects.equals(this.shippingInstructions, importDetails.shippingInstructions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.methodOfPayment, this.internationalCommercialTerms, this.portOfDelivery, this.importContainers, this.shippingInstructions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportDetails {\n");
        sb.append("    methodOfPayment: ").append(this.toIndentedString((Object)this.methodOfPayment)).append("\n");
        sb.append("    internationalCommercialTerms: ").append(this.toIndentedString((Object)this.internationalCommercialTerms)).append("\n");
        sb.append("    portOfDelivery: ").append(this.toIndentedString(this.portOfDelivery)).append("\n");
        sb.append("    importContainers: ").append(this.toIndentedString(this.importContainers)).append("\n");
        sb.append("    shippingInstructions: ").append(this.toIndentedString(this.shippingInstructions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum InternationalCommercialTermsEnum {
        EXWORKS("ExWorks"),
        FREECARRIER("FreeCarrier"),
        FREEONBOARD("FreeOnBoard"),
        FREEALONGSIDESHIP("FreeAlongSideShip"),
        CARRIAGEPAIDTO("CarriagePaidTo"),
        COSTANDFREIGHT("CostAndFreight"),
        CARRIAGEANDINSURANCEPAIDTO("CarriageAndInsurancePaidTo"),
        COSTINSURANCEANDFREIGHT("CostInsuranceAndFreight"),
        DELIVEREDATTERMINAL("DeliveredAtTerminal"),
        DELIVEREDATPLACE("DeliveredAtPlace"),
        DELIVERDUTYPAID("DeliverDutyPaid");

        private String value;

        private InternationalCommercialTermsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static InternationalCommercialTermsEnum fromValue(String input) {
            for (InternationalCommercialTermsEnum b : InternationalCommercialTermsEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<InternationalCommercialTermsEnum> {
            public void write(JsonWriter jsonWriter, InternationalCommercialTermsEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public InternationalCommercialTermsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return InternationalCommercialTermsEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MethodOfPaymentEnum {
        PAIDBYBUYER("PaidByBuyer"),
        COLLECTONDELIVERY("CollectOnDelivery"),
        DEFINEDBYBUYERANDSELLER("DefinedByBuyerAndSeller"),
        FOBPORTOFCALL("FOBPortOfCall"),
        PREPAIDBYSELLER("PrepaidBySeller"),
        PAIDBYSELLER("PaidBySeller");

        private String value;

        private MethodOfPaymentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MethodOfPaymentEnum fromValue(String input) {
            for (MethodOfPaymentEnum b : MethodOfPaymentEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MethodOfPaymentEnum> {
            public void write(JsonWriter jsonWriter, MethodOfPaymentEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public MethodOfPaymentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MethodOfPaymentEnum.fromValue(value);
            }
        }
    }
}

