/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.invoices.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="Terms of the payment for the invoice. The basis of the payment terms is the invoice date.")
public class PaymentTerms {
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="discountPercent")
    private String discountPercent = null;
    @SerializedName(value="discountDueDays")
    private BigDecimal discountDueDays = null;
    @SerializedName(value="netDueDays")
    private BigDecimal netDueDays = null;

    public PaymentTerms type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(description="The payment term type for the invoice.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PaymentTerms discountPercent(String discountPercent) {
        this.discountPercent = discountPercent;
        return this;
    }

    @Schema(description="")
    public String getDiscountPercent() {
        return this.discountPercent;
    }

    public void setDiscountPercent(String discountPercent) {
        this.discountPercent = discountPercent;
    }

    public PaymentTerms discountDueDays(BigDecimal discountDueDays) {
        this.discountDueDays = discountDueDays;
        return this;
    }

    @Schema(description="The number of calendar days from the Base date (Invoice date) until the discount is no longer valid.")
    public BigDecimal getDiscountDueDays() {
        return this.discountDueDays;
    }

    public void setDiscountDueDays(BigDecimal discountDueDays) {
        this.discountDueDays = discountDueDays;
    }

    public PaymentTerms netDueDays(BigDecimal netDueDays) {
        this.netDueDays = netDueDays;
        return this;
    }

    @Schema(description="The number of calendar days from the base date (invoice date) until the total amount on the invoice is due.")
    public BigDecimal getNetDueDays() {
        return this.netDueDays;
    }

    public void setNetDueDays(BigDecimal netDueDays) {
        this.netDueDays = netDueDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentTerms paymentTerms = (PaymentTerms)o;
        return Objects.equals((Object)this.type, (Object)paymentTerms.type) && Objects.equals(this.discountPercent, paymentTerms.discountPercent) && Objects.equals(this.discountDueDays, paymentTerms.discountDueDays) && Objects.equals(this.netDueDays, paymentTerms.netDueDays);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.discountPercent, this.discountDueDays, this.netDueDays});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentTerms {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    discountPercent: ").append(this.toIndentedString(this.discountPercent)).append("\n");
        sb.append("    discountDueDays: ").append(this.toIndentedString(this.discountDueDays)).append("\n");
        sb.append("    netDueDays: ").append(this.toIndentedString(this.netDueDays)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        BASIC("Basic"),
        ENDOFMONTH("EndOfMonth"),
        FIXEDDATE("FixedDate"),
        PROXIMO("Proximo"),
        PAYMENTDUEUPONRECEIPTOFINVOICE("PaymentDueUponReceiptOfInvoice"),
        LETTEROFCREDIT("LetterofCredit");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String input) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

