/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.invoices.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.invoices.v1.AllowanceDetails;
import software.amazon.spapi.models.vendor.invoices.v1.ChargeDetails;
import software.amazon.spapi.models.vendor.invoices.v1.CreditNoteDetails;
import software.amazon.spapi.models.vendor.invoices.v1.ItemQuantity;
import software.amazon.spapi.models.vendor.invoices.v1.Money;
import software.amazon.spapi.models.vendor.invoices.v1.NetCostUnitOfMeasure;
import software.amazon.spapi.models.vendor.invoices.v1.TaxDetails;

@Schema(description="Details of the item being invoiced.")
public class InvoiceItem {
    @SerializedName(value="itemSequenceNumber")
    private Integer itemSequenceNumber = null;
    @SerializedName(value="amazonProductIdentifier")
    private String amazonProductIdentifier = null;
    @SerializedName(value="vendorProductIdentifier")
    private String vendorProductIdentifier = null;
    @SerializedName(value="invoicedQuantity")
    private ItemQuantity invoicedQuantity = null;
    @SerializedName(value="netCost")
    private Money netCost = null;
    @SerializedName(value="netCostUnitOfMeasure")
    private NetCostUnitOfMeasure netCostUnitOfMeasure = null;
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="hsnCode")
    private String hsnCode = null;
    @SerializedName(value="creditNoteDetails")
    private CreditNoteDetails creditNoteDetails = null;
    @SerializedName(value="taxDetails")
    private List<TaxDetails> taxDetails = null;
    @SerializedName(value="chargeDetails")
    private List<ChargeDetails> chargeDetails = null;
    @SerializedName(value="allowanceDetails")
    private List<AllowanceDetails> allowanceDetails = null;

    public InvoiceItem itemSequenceNumber(Integer itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
        return this;
    }

    @Schema(required=true, description="Unique number related to this line item.")
    public Integer getItemSequenceNumber() {
        return this.itemSequenceNumber;
    }

    public void setItemSequenceNumber(Integer itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
    }

    public InvoiceItem amazonProductIdentifier(String amazonProductIdentifier) {
        this.amazonProductIdentifier = amazonProductIdentifier;
        return this;
    }

    @Schema(description="Amazon Standard Identification Number (ASIN) of an item.")
    public String getAmazonProductIdentifier() {
        return this.amazonProductIdentifier;
    }

    public void setAmazonProductIdentifier(String amazonProductIdentifier) {
        this.amazonProductIdentifier = amazonProductIdentifier;
    }

    public InvoiceItem vendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
        return this;
    }

    @Schema(description="The vendor selected product identifier of the item. Should be the same as was provided in the purchase order.")
    public String getVendorProductIdentifier() {
        return this.vendorProductIdentifier;
    }

    public void setVendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
    }

    public InvoiceItem invoicedQuantity(ItemQuantity invoicedQuantity) {
        this.invoicedQuantity = invoicedQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public ItemQuantity getInvoicedQuantity() {
        return this.invoicedQuantity;
    }

    public void setInvoicedQuantity(ItemQuantity invoicedQuantity) {
        this.invoicedQuantity = invoicedQuantity;
    }

    public InvoiceItem netCost(Money netCost) {
        this.netCost = netCost;
        return this;
    }

    @Schema(required=true, description="")
    public Money getNetCost() {
        return this.netCost;
    }

    public void setNetCost(Money netCost) {
        this.netCost = netCost;
    }

    public InvoiceItem netCostUnitOfMeasure(NetCostUnitOfMeasure netCostUnitOfMeasure) {
        this.netCostUnitOfMeasure = netCostUnitOfMeasure;
        return this;
    }

    @Schema(description="")
    public NetCostUnitOfMeasure getNetCostUnitOfMeasure() {
        return this.netCostUnitOfMeasure;
    }

    public void setNetCostUnitOfMeasure(NetCostUnitOfMeasure netCostUnitOfMeasure) {
        this.netCostUnitOfMeasure = netCostUnitOfMeasure;
    }

    public InvoiceItem purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(description="The Amazon purchase order number for this invoiced line item. Formatting Notes: 8-character alpha-numeric code. This value is mandatory only when invoiceType is Invoice, and is not required when invoiceType is CreditNote.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public InvoiceItem hsnCode(String hsnCode) {
        this.hsnCode = hsnCode;
        return this;
    }

    @Schema(description="HSN Tax code. The HSN number cannot contain alphabets.")
    public String getHsnCode() {
        return this.hsnCode;
    }

    public void setHsnCode(String hsnCode) {
        this.hsnCode = hsnCode;
    }

    public InvoiceItem creditNoteDetails(CreditNoteDetails creditNoteDetails) {
        this.creditNoteDetails = creditNoteDetails;
        return this;
    }

    @Schema(description="")
    public CreditNoteDetails getCreditNoteDetails() {
        return this.creditNoteDetails;
    }

    public void setCreditNoteDetails(CreditNoteDetails creditNoteDetails) {
        this.creditNoteDetails = creditNoteDetails;
    }

    public InvoiceItem taxDetails(List<TaxDetails> taxDetails) {
        this.taxDetails = taxDetails;
        return this;
    }

    public InvoiceItem addTaxDetailsItem(TaxDetails taxDetailsItem) {
        if (this.taxDetails == null) {
            this.taxDetails = new ArrayList<TaxDetails>();
        }
        this.taxDetails.add(taxDetailsItem);
        return this;
    }

    @Schema(description="Individual tax details per line item.")
    public List<TaxDetails> getTaxDetails() {
        return this.taxDetails;
    }

    public void setTaxDetails(List<TaxDetails> taxDetails) {
        this.taxDetails = taxDetails;
    }

    public InvoiceItem chargeDetails(List<ChargeDetails> chargeDetails) {
        this.chargeDetails = chargeDetails;
        return this;
    }

    public InvoiceItem addChargeDetailsItem(ChargeDetails chargeDetailsItem) {
        if (this.chargeDetails == null) {
            this.chargeDetails = new ArrayList<ChargeDetails>();
        }
        this.chargeDetails.add(chargeDetailsItem);
        return this;
    }

    @Schema(description="Individual charge details per line item.")
    public List<ChargeDetails> getChargeDetails() {
        return this.chargeDetails;
    }

    public void setChargeDetails(List<ChargeDetails> chargeDetails) {
        this.chargeDetails = chargeDetails;
    }

    public InvoiceItem allowanceDetails(List<AllowanceDetails> allowanceDetails) {
        this.allowanceDetails = allowanceDetails;
        return this;
    }

    public InvoiceItem addAllowanceDetailsItem(AllowanceDetails allowanceDetailsItem) {
        if (this.allowanceDetails == null) {
            this.allowanceDetails = new ArrayList<AllowanceDetails>();
        }
        this.allowanceDetails.add(allowanceDetailsItem);
        return this;
    }

    @Schema(description="Individual allowance details per line item.")
    public List<AllowanceDetails> getAllowanceDetails() {
        return this.allowanceDetails;
    }

    public void setAllowanceDetails(List<AllowanceDetails> allowanceDetails) {
        this.allowanceDetails = allowanceDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceItem invoiceItem = (InvoiceItem)o;
        return Objects.equals(this.itemSequenceNumber, invoiceItem.itemSequenceNumber) && Objects.equals(this.amazonProductIdentifier, invoiceItem.amazonProductIdentifier) && Objects.equals(this.vendorProductIdentifier, invoiceItem.vendorProductIdentifier) && Objects.equals(this.invoicedQuantity, invoiceItem.invoicedQuantity) && Objects.equals(this.netCost, invoiceItem.netCost) && Objects.equals((Object)this.netCostUnitOfMeasure, (Object)invoiceItem.netCostUnitOfMeasure) && Objects.equals(this.purchaseOrderNumber, invoiceItem.purchaseOrderNumber) && Objects.equals(this.hsnCode, invoiceItem.hsnCode) && Objects.equals(this.creditNoteDetails, invoiceItem.creditNoteDetails) && Objects.equals(this.taxDetails, invoiceItem.taxDetails) && Objects.equals(this.chargeDetails, invoiceItem.chargeDetails) && Objects.equals(this.allowanceDetails, invoiceItem.allowanceDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.itemSequenceNumber, this.amazonProductIdentifier, this.vendorProductIdentifier, this.invoicedQuantity, this.netCost, this.netCostUnitOfMeasure, this.purchaseOrderNumber, this.hsnCode, this.creditNoteDetails, this.taxDetails, this.chargeDetails, this.allowanceDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoiceItem {\n");
        sb.append("    itemSequenceNumber: ").append(this.toIndentedString(this.itemSequenceNumber)).append("\n");
        sb.append("    amazonProductIdentifier: ").append(this.toIndentedString(this.amazonProductIdentifier)).append("\n");
        sb.append("    vendorProductIdentifier: ").append(this.toIndentedString(this.vendorProductIdentifier)).append("\n");
        sb.append("    invoicedQuantity: ").append(this.toIndentedString(this.invoicedQuantity)).append("\n");
        sb.append("    netCost: ").append(this.toIndentedString(this.netCost)).append("\n");
        sb.append("    netCostUnitOfMeasure: ").append(this.toIndentedString((Object)this.netCostUnitOfMeasure)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    hsnCode: ").append(this.toIndentedString(this.hsnCode)).append("\n");
        sb.append("    creditNoteDetails: ").append(this.toIndentedString(this.creditNoteDetails)).append("\n");
        sb.append("    taxDetails: ").append(this.toIndentedString(this.taxDetails)).append("\n");
        sb.append("    chargeDetails: ").append(this.toIndentedString(this.chargeDetails)).append("\n");
        sb.append("    allowanceDetails: ").append(this.toIndentedString(this.allowanceDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

