/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.invoices.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.invoices.v1.AdditionalDetails;
import software.amazon.spapi.models.vendor.invoices.v1.AllowanceDetails;
import software.amazon.spapi.models.vendor.invoices.v1.ChargeDetails;
import software.amazon.spapi.models.vendor.invoices.v1.InvoiceItem;
import software.amazon.spapi.models.vendor.invoices.v1.Money;
import software.amazon.spapi.models.vendor.invoices.v1.PartyIdentification;
import software.amazon.spapi.models.vendor.invoices.v1.PaymentTerms;
import software.amazon.spapi.models.vendor.invoices.v1.TaxDetails;

@Schema(description="Represents an invoice or credit note document with details about the transaction, parties involved, and line items.")
public class Invoice {
    @SerializedName(value="invoiceType")
    private InvoiceTypeEnum invoiceType = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="referenceNumber")
    private String referenceNumber = null;
    @SerializedName(value="date")
    private OffsetDateTime date = null;
    @SerializedName(value="remitToParty")
    private PartyIdentification remitToParty = null;
    @SerializedName(value="shipToParty")
    private PartyIdentification shipToParty = null;
    @SerializedName(value="shipFromParty")
    private PartyIdentification shipFromParty = null;
    @SerializedName(value="billToParty")
    private PartyIdentification billToParty = null;
    @SerializedName(value="paymentTerms")
    private PaymentTerms paymentTerms = null;
    @SerializedName(value="invoiceTotal")
    private Money invoiceTotal = null;
    @SerializedName(value="taxDetails")
    private List<TaxDetails> taxDetails = null;
    @SerializedName(value="additionalDetails")
    private List<AdditionalDetails> additionalDetails = null;
    @SerializedName(value="chargeDetails")
    private List<ChargeDetails> chargeDetails = null;
    @SerializedName(value="allowanceDetails")
    private List<AllowanceDetails> allowanceDetails = null;
    @SerializedName(value="items")
    private List<InvoiceItem> items = null;

    public Invoice invoiceType(InvoiceTypeEnum invoiceType) {
        this.invoiceType = invoiceType;
        return this;
    }

    @Schema(required=true, description="Identifies the type of invoice.")
    public InvoiceTypeEnum getInvoiceType() {
        return this.invoiceType;
    }

    public void setInvoiceType(InvoiceTypeEnum invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Invoice id(String id) {
        this.id = id;
        return this;
    }

    @Schema(required=true, description="Unique number relating to the charges defined in this document. This will be invoice number if the document type is Invoice or CreditNote number if the document type is Credit Note. Failure to provide this reference will result in a rejection.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Invoice referenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
        return this;
    }

    @Schema(description="An additional unique reference number used for regulatory or other purposes.")
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public Invoice date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Schema(required=true, description="")
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public Invoice remitToParty(PartyIdentification remitToParty) {
        this.remitToParty = remitToParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getRemitToParty() {
        return this.remitToParty;
    }

    public void setRemitToParty(PartyIdentification remitToParty) {
        this.remitToParty = remitToParty;
    }

    public Invoice shipToParty(PartyIdentification shipToParty) {
        this.shipToParty = shipToParty;
        return this;
    }

    @Schema(description="")
    public PartyIdentification getShipToParty() {
        return this.shipToParty;
    }

    public void setShipToParty(PartyIdentification shipToParty) {
        this.shipToParty = shipToParty;
    }

    public Invoice shipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
        return this;
    }

    @Schema(description="")
    public PartyIdentification getShipFromParty() {
        return this.shipFromParty;
    }

    public void setShipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
    }

    public Invoice billToParty(PartyIdentification billToParty) {
        this.billToParty = billToParty;
        return this;
    }

    @Schema(description="")
    public PartyIdentification getBillToParty() {
        return this.billToParty;
    }

    public void setBillToParty(PartyIdentification billToParty) {
        this.billToParty = billToParty;
    }

    public Invoice paymentTerms(PaymentTerms paymentTerms) {
        this.paymentTerms = paymentTerms;
        return this;
    }

    @Schema(description="")
    public PaymentTerms getPaymentTerms() {
        return this.paymentTerms;
    }

    public void setPaymentTerms(PaymentTerms paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public Invoice invoiceTotal(Money invoiceTotal) {
        this.invoiceTotal = invoiceTotal;
        return this;
    }

    @Schema(required=true, description="")
    public Money getInvoiceTotal() {
        return this.invoiceTotal;
    }

    public void setInvoiceTotal(Money invoiceTotal) {
        this.invoiceTotal = invoiceTotal;
    }

    public Invoice taxDetails(List<TaxDetails> taxDetails) {
        this.taxDetails = taxDetails;
        return this;
    }

    public Invoice addTaxDetailsItem(TaxDetails taxDetailsItem) {
        if (this.taxDetails == null) {
            this.taxDetails = new ArrayList<TaxDetails>();
        }
        this.taxDetails.add(taxDetailsItem);
        return this;
    }

    @Schema(description="Total tax amount details for all line items.")
    public List<TaxDetails> getTaxDetails() {
        return this.taxDetails;
    }

    public void setTaxDetails(List<TaxDetails> taxDetails) {
        this.taxDetails = taxDetails;
    }

    public Invoice additionalDetails(List<AdditionalDetails> additionalDetails) {
        this.additionalDetails = additionalDetails;
        return this;
    }

    public Invoice addAdditionalDetailsItem(AdditionalDetails additionalDetailsItem) {
        if (this.additionalDetails == null) {
            this.additionalDetails = new ArrayList<AdditionalDetails>();
        }
        this.additionalDetails.add(additionalDetailsItem);
        return this;
    }

    @Schema(description="Additional details provided by the selling party, for tax related or other purposes.")
    public List<AdditionalDetails> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public void setAdditionalDetails(List<AdditionalDetails> additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public Invoice chargeDetails(List<ChargeDetails> chargeDetails) {
        this.chargeDetails = chargeDetails;
        return this;
    }

    public Invoice addChargeDetailsItem(ChargeDetails chargeDetailsItem) {
        if (this.chargeDetails == null) {
            this.chargeDetails = new ArrayList<ChargeDetails>();
        }
        this.chargeDetails.add(chargeDetailsItem);
        return this;
    }

    @Schema(description="Total charge amount details for all line items.")
    public List<ChargeDetails> getChargeDetails() {
        return this.chargeDetails;
    }

    public void setChargeDetails(List<ChargeDetails> chargeDetails) {
        this.chargeDetails = chargeDetails;
    }

    public Invoice allowanceDetails(List<AllowanceDetails> allowanceDetails) {
        this.allowanceDetails = allowanceDetails;
        return this;
    }

    public Invoice addAllowanceDetailsItem(AllowanceDetails allowanceDetailsItem) {
        if (this.allowanceDetails == null) {
            this.allowanceDetails = new ArrayList<AllowanceDetails>();
        }
        this.allowanceDetails.add(allowanceDetailsItem);
        return this;
    }

    @Schema(description="Total allowance amount details for all line items.")
    public List<AllowanceDetails> getAllowanceDetails() {
        return this.allowanceDetails;
    }

    public void setAllowanceDetails(List<AllowanceDetails> allowanceDetails) {
        this.allowanceDetails = allowanceDetails;
    }

    public Invoice items(List<InvoiceItem> items) {
        this.items = items;
        return this;
    }

    public Invoice addItemsItem(InvoiceItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<InvoiceItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Schema(description="The list of invoice items.")
    public List<InvoiceItem> getItems() {
        return this.items;
    }

    public void setItems(List<InvoiceItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invoice invoice = (Invoice)o;
        return Objects.equals((Object)this.invoiceType, (Object)invoice.invoiceType) && Objects.equals(this.id, invoice.id) && Objects.equals(this.referenceNumber, invoice.referenceNumber) && Objects.equals(this.date, invoice.date) && Objects.equals(this.remitToParty, invoice.remitToParty) && Objects.equals(this.shipToParty, invoice.shipToParty) && Objects.equals(this.shipFromParty, invoice.shipFromParty) && Objects.equals(this.billToParty, invoice.billToParty) && Objects.equals(this.paymentTerms, invoice.paymentTerms) && Objects.equals(this.invoiceTotal, invoice.invoiceTotal) && Objects.equals(this.taxDetails, invoice.taxDetails) && Objects.equals(this.additionalDetails, invoice.additionalDetails) && Objects.equals(this.chargeDetails, invoice.chargeDetails) && Objects.equals(this.allowanceDetails, invoice.allowanceDetails) && Objects.equals(this.items, invoice.items);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.invoiceType, this.id, this.referenceNumber, this.date, this.remitToParty, this.shipToParty, this.shipFromParty, this.billToParty, this.paymentTerms, this.invoiceTotal, this.taxDetails, this.additionalDetails, this.chargeDetails, this.allowanceDetails, this.items});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Invoice {\n");
        sb.append("    invoiceType: ").append(this.toIndentedString((Object)this.invoiceType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    referenceNumber: ").append(this.toIndentedString(this.referenceNumber)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    remitToParty: ").append(this.toIndentedString(this.remitToParty)).append("\n");
        sb.append("    shipToParty: ").append(this.toIndentedString(this.shipToParty)).append("\n");
        sb.append("    shipFromParty: ").append(this.toIndentedString(this.shipFromParty)).append("\n");
        sb.append("    billToParty: ").append(this.toIndentedString(this.billToParty)).append("\n");
        sb.append("    paymentTerms: ").append(this.toIndentedString(this.paymentTerms)).append("\n");
        sb.append("    invoiceTotal: ").append(this.toIndentedString(this.invoiceTotal)).append("\n");
        sb.append("    taxDetails: ").append(this.toIndentedString(this.taxDetails)).append("\n");
        sb.append("    additionalDetails: ").append(this.toIndentedString(this.additionalDetails)).append("\n");
        sb.append("    chargeDetails: ").append(this.toIndentedString(this.chargeDetails)).append("\n");
        sb.append("    allowanceDetails: ").append(this.toIndentedString(this.allowanceDetails)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum InvoiceTypeEnum {
        INVOICE("Invoice"),
        CREDITNOTE("CreditNote");

        private String value;

        private InvoiceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static InvoiceTypeEnum fromValue(String input) {
            for (InvoiceTypeEnum b : InvoiceTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<InvoiceTypeEnum> {
            public void write(JsonWriter jsonWriter, InvoiceTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public InvoiceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return InvoiceTypeEnum.fromValue(value);
            }
        }
    }
}

