/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.invoices.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.invoices.v1.Money;
import software.amazon.spapi.models.vendor.invoices.v1.TaxDetails;

@Schema(description="Monetary and tax details of the charge.")
public class ChargeDetails {
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="chargeAmount")
    private Money chargeAmount = null;
    @SerializedName(value="taxDetails")
    private List<TaxDetails> taxDetails = null;

    public ChargeDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(required=true, description="Type of the charge applied.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ChargeDetails description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the charge.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ChargeDetails chargeAmount(Money chargeAmount) {
        this.chargeAmount = chargeAmount;
        return this;
    }

    @Schema(required=true, description="")
    public Money getChargeAmount() {
        return this.chargeAmount;
    }

    public void setChargeAmount(Money chargeAmount) {
        this.chargeAmount = chargeAmount;
    }

    public ChargeDetails taxDetails(List<TaxDetails> taxDetails) {
        this.taxDetails = taxDetails;
        return this;
    }

    public ChargeDetails addTaxDetailsItem(TaxDetails taxDetailsItem) {
        if (this.taxDetails == null) {
            this.taxDetails = new ArrayList<TaxDetails>();
        }
        this.taxDetails.add(taxDetailsItem);
        return this;
    }

    @Schema(description="Tax amount details applied on this charge.")
    public List<TaxDetails> getTaxDetails() {
        return this.taxDetails;
    }

    public void setTaxDetails(List<TaxDetails> taxDetails) {
        this.taxDetails = taxDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargeDetails chargeDetails = (ChargeDetails)o;
        return Objects.equals((Object)this.type, (Object)chargeDetails.type) && Objects.equals(this.description, chargeDetails.description) && Objects.equals(this.chargeAmount, chargeDetails.chargeAmount) && Objects.equals(this.taxDetails, chargeDetails.taxDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.description, this.chargeAmount, this.taxDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChargeDetails {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    chargeAmount: ").append(this.toIndentedString(this.chargeAmount)).append("\n");
        sb.append("    taxDetails: ").append(this.toIndentedString(this.taxDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        FREIGHT("Freight"),
        PACKING("Packing"),
        DUTY("Duty"),
        SERVICE("Service"),
        SMALLORDER("SmallOrder"),
        INSURANCEPLACEMENTCOST("InsurancePlacementCost"),
        INSURANCEFEE("InsuranceFee"),
        SPECIALHANDLINGSERVICE("SpecialHandlingService"),
        COLLECTIONANDRECYCLINGSERVICE("CollectionAndRecyclingService"),
        ENVIRONMENTALPROTECTIONSERVICE("EnvironmentalProtectionService"),
        TAXCOLLECTEDATSOURCE("TaxCollectedAtSource");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String input) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

