/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.invoices.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.invoices.v1.Money;
import software.amazon.spapi.models.vendor.invoices.v1.TaxDetails;

@Schema(description="Monetary and tax details of the allowance.")
public class AllowanceDetails {
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="allowanceAmount")
    private Money allowanceAmount = null;
    @SerializedName(value="taxDetails")
    private List<TaxDetails> taxDetails = null;

    public AllowanceDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(required=true, description="Type of the allowance applied.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AllowanceDetails description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the allowance.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AllowanceDetails allowanceAmount(Money allowanceAmount) {
        this.allowanceAmount = allowanceAmount;
        return this;
    }

    @Schema(required=true, description="")
    public Money getAllowanceAmount() {
        return this.allowanceAmount;
    }

    public void setAllowanceAmount(Money allowanceAmount) {
        this.allowanceAmount = allowanceAmount;
    }

    public AllowanceDetails taxDetails(List<TaxDetails> taxDetails) {
        this.taxDetails = taxDetails;
        return this;
    }

    public AllowanceDetails addTaxDetailsItem(TaxDetails taxDetailsItem) {
        if (this.taxDetails == null) {
            this.taxDetails = new ArrayList<TaxDetails>();
        }
        this.taxDetails.add(taxDetailsItem);
        return this;
    }

    @Schema(description="Tax amount details applied on this allowance.")
    public List<TaxDetails> getTaxDetails() {
        return this.taxDetails;
    }

    public void setTaxDetails(List<TaxDetails> taxDetails) {
        this.taxDetails = taxDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllowanceDetails allowanceDetails = (AllowanceDetails)o;
        return Objects.equals((Object)this.type, (Object)allowanceDetails.type) && Objects.equals(this.description, allowanceDetails.description) && Objects.equals(this.allowanceAmount, allowanceDetails.allowanceAmount) && Objects.equals(this.taxDetails, allowanceDetails.taxDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.description, this.allowanceAmount, this.taxDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AllowanceDetails {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    allowanceAmount: ").append(this.toIndentedString(this.allowanceAmount)).append("\n");
        sb.append("    taxDetails: ").append(this.toIndentedString(this.taxDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        DISCOUNT("Discount"),
        DISCOUNTINCENTIVE("DiscountIncentive"),
        DEFECTIVE("Defective"),
        PROMOTIONAL("Promotional"),
        UNSALEABLEMERCHANDISE("UnsaleableMerchandise"),
        SPECIAL("Special");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String input) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

