/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.transactions.v2021_12_28;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.transactions.v2021_12_28.ErrorList;

@Schema(description="The transaction status details.")
public class Transaction {
    @SerializedName(value="transactionId")
    private String transactionId = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="errors")
    private ErrorList errors = null;

    public Transaction transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Schema(required=true, description="The unique identifier sent in the 'transactionId' field in response to the post request of a specific transaction.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Transaction status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="Current processing status of the transaction.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Transaction errors(ErrorList errors) {
        this.errors = errors;
        return this;
    }

    @Schema(description="")
    public ErrorList getErrors() {
        return this.errors;
    }

    public void setErrors(ErrorList errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals(this.transactionId, transaction.transactionId) && Objects.equals((Object)this.status, (Object)transaction.status) && Objects.equals(this.errors, transaction.errors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionId, this.status, this.errors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        FAILURE("Failure"),
        PROCESSING("Processing"),
        SUCCESS("Success");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String input) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

