/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.shipping.v2021_12_28;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.Address;

@Schema(description="Tax registration details of the entity.")
public class TaxRegistrationDetails {
    @SerializedName(value="taxRegistrationType")
    private TaxRegistrationTypeEnum taxRegistrationType = null;
    @SerializedName(value="taxRegistrationNumber")
    private String taxRegistrationNumber = null;
    @SerializedName(value="taxRegistrationAddress")
    private Address taxRegistrationAddress = null;
    @SerializedName(value="taxRegistrationMessages")
    private String taxRegistrationMessages = null;

    public TaxRegistrationDetails taxRegistrationType(TaxRegistrationTypeEnum taxRegistrationType) {
        this.taxRegistrationType = taxRegistrationType;
        return this;
    }

    @Schema(description="Tax registration type for the entity.")
    public TaxRegistrationTypeEnum getTaxRegistrationType() {
        return this.taxRegistrationType;
    }

    public void setTaxRegistrationType(TaxRegistrationTypeEnum taxRegistrationType) {
        this.taxRegistrationType = taxRegistrationType;
    }

    public TaxRegistrationDetails taxRegistrationNumber(String taxRegistrationNumber) {
        this.taxRegistrationNumber = taxRegistrationNumber;
        return this;
    }

    @Schema(required=true, description="Tax registration number for the party. For example, VAT ID.")
    public String getTaxRegistrationNumber() {
        return this.taxRegistrationNumber;
    }

    public void setTaxRegistrationNumber(String taxRegistrationNumber) {
        this.taxRegistrationNumber = taxRegistrationNumber;
    }

    public TaxRegistrationDetails taxRegistrationAddress(Address taxRegistrationAddress) {
        this.taxRegistrationAddress = taxRegistrationAddress;
        return this;
    }

    @Schema(description="")
    public Address getTaxRegistrationAddress() {
        return this.taxRegistrationAddress;
    }

    public void setTaxRegistrationAddress(Address taxRegistrationAddress) {
        this.taxRegistrationAddress = taxRegistrationAddress;
    }

    public TaxRegistrationDetails taxRegistrationMessages(String taxRegistrationMessages) {
        this.taxRegistrationMessages = taxRegistrationMessages;
        return this;
    }

    @Schema(description="Tax registration message that can be used for additional tax related details.")
    public String getTaxRegistrationMessages() {
        return this.taxRegistrationMessages;
    }

    public void setTaxRegistrationMessages(String taxRegistrationMessages) {
        this.taxRegistrationMessages = taxRegistrationMessages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxRegistrationDetails taxRegistrationDetails = (TaxRegistrationDetails)o;
        return Objects.equals((Object)this.taxRegistrationType, (Object)taxRegistrationDetails.taxRegistrationType) && Objects.equals(this.taxRegistrationNumber, taxRegistrationDetails.taxRegistrationNumber) && Objects.equals(this.taxRegistrationAddress, taxRegistrationDetails.taxRegistrationAddress) && Objects.equals(this.taxRegistrationMessages, taxRegistrationDetails.taxRegistrationMessages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taxRegistrationType, this.taxRegistrationNumber, this.taxRegistrationAddress, this.taxRegistrationMessages});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxRegistrationDetails {\n");
        sb.append("    taxRegistrationType: ").append(this.toIndentedString((Object)this.taxRegistrationType)).append("\n");
        sb.append("    taxRegistrationNumber: ").append(this.toIndentedString(this.taxRegistrationNumber)).append("\n");
        sb.append("    taxRegistrationAddress: ").append(this.toIndentedString(this.taxRegistrationAddress)).append("\n");
        sb.append("    taxRegistrationMessages: ").append(this.toIndentedString(this.taxRegistrationMessages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TaxRegistrationTypeEnum {
        VAT("VAT"),
        GST("GST");

        private String value;

        private TaxRegistrationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TaxRegistrationTypeEnum fromValue(String input) {
            for (TaxRegistrationTypeEnum b : TaxRegistrationTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TaxRegistrationTypeEnum> {
            public void write(JsonWriter jsonWriter, TaxRegistrationTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TaxRegistrationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TaxRegistrationTypeEnum.fromValue(value);
            }
        }
    }
}

