/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.shipping.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.Container;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.PartyIdentification;

@Schema(description="Represents the request payload for creating a shipping label, containing the purchase order number, selling party, ship from party, and a list of containers or packages in the shipment.")
public class ShippingLabelRequest {
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="sellingParty")
    private PartyIdentification sellingParty = null;
    @SerializedName(value="shipFromParty")
    private PartyIdentification shipFromParty = null;
    @SerializedName(value="containers")
    private List<Container> containers = null;

    public ShippingLabelRequest purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(required=true, description="The purchase order number of the order for which to create a shipping label.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public ShippingLabelRequest sellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getSellingParty() {
        return this.sellingParty;
    }

    public void setSellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
    }

    public ShippingLabelRequest shipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getShipFromParty() {
        return this.shipFromParty;
    }

    public void setShipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
    }

    public ShippingLabelRequest containers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    public ShippingLabelRequest addContainersItem(Container containersItem) {
        if (this.containers == null) {
            this.containers = new ArrayList<Container>();
        }
        this.containers.add(containersItem);
        return this;
    }

    @Schema(description="A list of the packages in this shipment.")
    public List<Container> getContainers() {
        return this.containers;
    }

    public void setContainers(List<Container> containers) {
        this.containers = containers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShippingLabelRequest shippingLabelRequest = (ShippingLabelRequest)o;
        return Objects.equals(this.purchaseOrderNumber, shippingLabelRequest.purchaseOrderNumber) && Objects.equals(this.sellingParty, shippingLabelRequest.sellingParty) && Objects.equals(this.shipFromParty, shippingLabelRequest.shipFromParty) && Objects.equals(this.containers, shippingLabelRequest.containers);
    }

    public int hashCode() {
        return Objects.hash(this.purchaseOrderNumber, this.sellingParty, this.shipFromParty, this.containers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShippingLabelRequest {\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    sellingParty: ").append(this.toIndentedString(this.sellingParty)).append("\n");
        sb.append("    shipFromParty: ").append(this.toIndentedString(this.shipFromParty)).append("\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

