/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.shipping.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Details about the estimated delivery window.")
public class ShipmentSchedule {
    @SerializedName(value="estimatedDeliveryDateTime")
    private OffsetDateTime estimatedDeliveryDateTime = null;
    @SerializedName(value="apptWindowStartDateTime")
    private OffsetDateTime apptWindowStartDateTime = null;
    @SerializedName(value="apptWindowEndDateTime")
    private OffsetDateTime apptWindowEndDateTime = null;

    public ShipmentSchedule estimatedDeliveryDateTime(OffsetDateTime estimatedDeliveryDateTime) {
        this.estimatedDeliveryDateTime = estimatedDeliveryDateTime;
        return this;
    }

    @Schema(description="Date on which the shipment is expected to reach the customer delivery location. Values are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format, with UTC time zone or UTC offset. For example, 2020-07-16T23:00:00Z or 2020-07-16T23:00:00+01:00.")
    public OffsetDateTime getEstimatedDeliveryDateTime() {
        return this.estimatedDeliveryDateTime;
    }

    public void setEstimatedDeliveryDateTime(OffsetDateTime estimatedDeliveryDateTime) {
        this.estimatedDeliveryDateTime = estimatedDeliveryDateTime;
    }

    public ShipmentSchedule apptWindowStartDateTime(OffsetDateTime apptWindowStartDateTime) {
        this.apptWindowStartDateTime = apptWindowStartDateTime;
        return this;
    }

    @Schema(description="The date and time at the start of the appointment window when the shipment is expected to be delivered. Values are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format, with UTC time zone or UTC offset. For example, 2020-07-16T23:00:00Z or 2020-07-16T23:00:00+01:00.")
    public OffsetDateTime getApptWindowStartDateTime() {
        return this.apptWindowStartDateTime;
    }

    public void setApptWindowStartDateTime(OffsetDateTime apptWindowStartDateTime) {
        this.apptWindowStartDateTime = apptWindowStartDateTime;
    }

    public ShipmentSchedule apptWindowEndDateTime(OffsetDateTime apptWindowEndDateTime) {
        this.apptWindowEndDateTime = apptWindowEndDateTime;
        return this;
    }

    @Schema(description="The date and time at the end of the appointment window when the shipment is expected to be delivered. Values are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format, with UTC time zone or UTC offset. For example, 2020-07-16T23:00:00Z or 2020-07-16T23:00:00+01:00.")
    public OffsetDateTime getApptWindowEndDateTime() {
        return this.apptWindowEndDateTime;
    }

    public void setApptWindowEndDateTime(OffsetDateTime apptWindowEndDateTime) {
        this.apptWindowEndDateTime = apptWindowEndDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentSchedule shipmentSchedule = (ShipmentSchedule)o;
        return Objects.equals(this.estimatedDeliveryDateTime, shipmentSchedule.estimatedDeliveryDateTime) && Objects.equals(this.apptWindowStartDateTime, shipmentSchedule.apptWindowStartDateTime) && Objects.equals(this.apptWindowEndDateTime, shipmentSchedule.apptWindowEndDateTime);
    }

    public int hashCode() {
        return Objects.hash(this.estimatedDeliveryDateTime, this.apptWindowStartDateTime, this.apptWindowEndDateTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentSchedule {\n");
        sb.append("    estimatedDeliveryDateTime: ").append(this.toIndentedString(this.estimatedDeliveryDateTime)).append("\n");
        sb.append("    apptWindowStartDateTime: ").append(this.toIndentedString(this.apptWindowStartDateTime)).append("\n");
        sb.append("    apptWindowEndDateTime: ").append(this.toIndentedString(this.apptWindowEndDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

