/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.shipping.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.Container;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.Item;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.PartyIdentification;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.ShipmentDetails;

@Schema(description="Represents the confirmation details of a shipment, including the purchase order number and other shipment details.")
public class ShipmentConfirmation {
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="shipmentDetails")
    private ShipmentDetails shipmentDetails = null;
    @SerializedName(value="sellingParty")
    private PartyIdentification sellingParty = null;
    @SerializedName(value="shipFromParty")
    private PartyIdentification shipFromParty = null;
    @SerializedName(value="items")
    private List<Item> items = new ArrayList<Item>();
    @SerializedName(value="containers")
    private List<Container> containers = null;

    public ShipmentConfirmation purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(required=true, description="Purchase order number corresponding to the shipment.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public ShipmentConfirmation shipmentDetails(ShipmentDetails shipmentDetails) {
        this.shipmentDetails = shipmentDetails;
        return this;
    }

    @Schema(required=true, description="")
    public ShipmentDetails getShipmentDetails() {
        return this.shipmentDetails;
    }

    public void setShipmentDetails(ShipmentDetails shipmentDetails) {
        this.shipmentDetails = shipmentDetails;
    }

    public ShipmentConfirmation sellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getSellingParty() {
        return this.sellingParty;
    }

    public void setSellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
    }

    public ShipmentConfirmation shipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getShipFromParty() {
        return this.shipFromParty;
    }

    public void setShipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
    }

    public ShipmentConfirmation items(List<Item> items) {
        this.items = items;
        return this;
    }

    public ShipmentConfirmation addItemsItem(Item itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Schema(required=true, description="Provide the details of the items in this shipment. If any of the item details field is common at a package or a pallet level, then provide them at the corresponding package.")
    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public ShipmentConfirmation containers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    public ShipmentConfirmation addContainersItem(Container containersItem) {
        if (this.containers == null) {
            this.containers = new ArrayList<Container>();
        }
        this.containers.add(containersItem);
        return this;
    }

    @Schema(description="Provide the details of the items in this shipment. If any of the item details field is common at a package or a pallet level, then provide them at the corresponding package.")
    public List<Container> getContainers() {
        return this.containers;
    }

    public void setContainers(List<Container> containers) {
        this.containers = containers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentConfirmation shipmentConfirmation = (ShipmentConfirmation)o;
        return Objects.equals(this.purchaseOrderNumber, shipmentConfirmation.purchaseOrderNumber) && Objects.equals(this.shipmentDetails, shipmentConfirmation.shipmentDetails) && Objects.equals(this.sellingParty, shipmentConfirmation.sellingParty) && Objects.equals(this.shipFromParty, shipmentConfirmation.shipFromParty) && Objects.equals(this.items, shipmentConfirmation.items) && Objects.equals(this.containers, shipmentConfirmation.containers);
    }

    public int hashCode() {
        return Objects.hash(this.purchaseOrderNumber, this.shipmentDetails, this.sellingParty, this.shipFromParty, this.items, this.containers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentConfirmation {\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    shipmentDetails: ").append(this.toIndentedString(this.shipmentDetails)).append("\n");
        sb.append("    sellingParty: ").append(this.toIndentedString(this.sellingParty)).append("\n");
        sb.append("    shipFromParty: ").append(this.toIndentedString(this.shipFromParty)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

