/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.shipping.v2021_12_28;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Packing slip information.")
public class PackingSlip {
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="content")
    private String content = null;
    @SerializedName(value="contentType")
    private ContentTypeEnum contentType = null;

    public PackingSlip purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(required=true, description="Purchase order number of the shipment that the packing slip is for.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public PackingSlip content(String content) {
        this.content = content;
        return this;
    }

    @Schema(required=true, description="A Base64 string of the packing slip PDF.")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public PackingSlip contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @Schema(description="The format of the file such as PDF, JPEG etc.")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackingSlip packingSlip = (PackingSlip)o;
        return Objects.equals(this.purchaseOrderNumber, packingSlip.purchaseOrderNumber) && Objects.equals(this.content, packingSlip.content) && Objects.equals((Object)this.contentType, (Object)packingSlip.contentType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.purchaseOrderNumber, this.content, this.contentType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PackingSlip {\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContentTypeEnum {
        APPLICATION_PDF("application/pdf");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContentTypeEnum fromValue(String input) {
            for (ContentTypeEnum b : ContentTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ContentTypeEnum> {
            public void write(JsonWriter jsonWriter, ContentTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ContentTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContentTypeEnum.fromValue(value);
            }
        }
    }
}

