/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.shipping.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Details of the shipment label.")
public class LabelData {
    @SerializedName(value="packageIdentifier")
    private String packageIdentifier = null;
    @SerializedName(value="trackingNumber")
    private String trackingNumber = null;
    @SerializedName(value="shipMethod")
    private String shipMethod = null;
    @SerializedName(value="shipMethodName")
    private String shipMethodName = null;
    @SerializedName(value="content")
    private String content = null;

    public LabelData packageIdentifier(String packageIdentifier) {
        this.packageIdentifier = packageIdentifier;
        return this;
    }

    @Schema(description="Identifier for the package. The first package will be 001, the second 002, and so on. This number is used as a reference to refer to this package from the pallet level.")
    public String getPackageIdentifier() {
        return this.packageIdentifier;
    }

    public void setPackageIdentifier(String packageIdentifier) {
        this.packageIdentifier = packageIdentifier;
    }

    public LabelData trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @Schema(description="Package tracking identifier from the shipping carrier.")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public LabelData shipMethod(String shipMethod) {
        this.shipMethod = shipMethod;
        return this;
    }

    @Schema(description="Ship method to be used for shipping the order. Amazon defines Ship Method Codes indicating shipping carrier and shipment service level. Ship Method Codes are case and format sensitive. The same ship method code should returned on the shipment confirmation. Note that the Ship Method Codes are vendor specific and will be provided to each vendor during the implementation.")
    public String getShipMethod() {
        return this.shipMethod;
    }

    public void setShipMethod(String shipMethod) {
        this.shipMethod = shipMethod;
    }

    public LabelData shipMethodName(String shipMethodName) {
        this.shipMethodName = shipMethodName;
        return this;
    }

    @Schema(description="Shipping method name for internal reference.")
    public String getShipMethodName() {
        return this.shipMethodName;
    }

    public void setShipMethodName(String shipMethodName) {
        this.shipMethodName = shipMethodName;
    }

    public LabelData content(String content) {
        this.content = content;
        return this;
    }

    @Schema(required=true, description="This field will contain the Base64 string of the shipment label content.")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelData labelData = (LabelData)o;
        return Objects.equals(this.packageIdentifier, labelData.packageIdentifier) && Objects.equals(this.trackingNumber, labelData.trackingNumber) && Objects.equals(this.shipMethod, labelData.shipMethod) && Objects.equals(this.shipMethodName, labelData.shipMethodName) && Objects.equals(this.content, labelData.content);
    }

    public int hashCode() {
        return Objects.hash(this.packageIdentifier, this.trackingNumber, this.shipMethod, this.shipMethodName, this.content);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LabelData {\n");
        sb.append("    packageIdentifier: ").append(this.toIndentedString(this.packageIdentifier)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("    shipMethod: ").append(this.toIndentedString(this.shipMethod)).append("\n");
        sb.append("    shipMethodName: ").append(this.toIndentedString(this.shipMethodName)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

